/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.DatasetRecordException;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.Syncable;
import org.kitesdk.data.UnknownFormatException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.AbstractDatasetWriter;
import org.kitesdk.data.spi.DescriptorUtil;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.AvroAppender;
import org.kitesdk.data.spi.filesystem.CSVAppender;
import org.kitesdk.data.spi.filesystem.DurableParquetAppender;
import org.kitesdk.data.spi.filesystem.ParquetAppender;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Throwables;
import org.kitesdk.shaded.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemWriter<E>
extends AbstractDatasetWriter<E> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemWriter.class);
    private static final Set<Format> SUPPORTED_FORMATS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Formats.AVRO)).add(Formats.PARQUET)).build();
    private final Path directory;
    private final DatasetDescriptor descriptor;
    private Path tempPath;
    private Path finalPath;
    private int count = 0;
    protected final FileSystem fs;
    protected FileAppender<E> appender;
    protected boolean flushed = false;
    @VisibleForTesting
    ReaderWriterState state;
    @VisibleForTesting
    final Configuration conf;

    static boolean isSupportedFormat(DatasetDescriptor descriptor) {
        Format format = descriptor.getFormat();
        return SUPPORTED_FORMATS.contains(format) || Formats.CSV.equals(format) && DescriptorUtil.isEnabled("kite.allow.csv", descriptor);
    }

    private FileSystemWriter(FileSystem fs, Path path, DatasetDescriptor descriptor) {
        Preconditions.checkNotNull(fs, "File system is not defined");
        Preconditions.checkNotNull(path, "Destination directory is not defined");
        Preconditions.checkNotNull(descriptor, "Descriptor is not defined");
        this.fs = fs;
        this.directory = path;
        this.descriptor = descriptor;
        this.conf = new Configuration(fs.getConf());
        this.state = ReaderWriterState.NEW;
        for (String prop : descriptor.listProperties()) {
            this.conf.set(prop, descriptor.getProperty(prop));
        }
    }

    @Override
    public final void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "Unable to open a writer from state:%s", new Object[]{this.state});
        ValidationException.check(FileSystemWriter.isSupportedFormat(this.descriptor), "Not a supported format: %s", this.descriptor.getFormat());
        try {
            this.fs.mkdirs(this.directory);
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException(e, "Failed to create path %s", this.directory);
        }
        catch (IOException ex) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Failed to create path " + this.directory, ex);
        }
        try {
            this.finalPath = new Path(this.directory, FileSystemWriter.uniqueFilename(this.descriptor.getFormat()));
            this.tempPath = FileSystemWriter.tempFilename(this.finalPath);
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException(e, "Failed to initialize file paths under %s", this.directory);
        }
        try {
            this.appender = this.newAppender(this.tempPath);
            this.appender.open();
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException(e, "Failed to open appender %s", this.appender);
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Failed to open appender " + this.appender, e);
        }
        this.count = 0;
        LOG.info("Opened output appender {} for {}", this.appender, (Object)this.finalPath);
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public final void write(E entity) {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to write to a writer in state:%s", new Object[]{this.state});
        try {
            this.appender.append(entity);
            ++this.count;
        }
        catch (RuntimeException e) {
            Throwables.propagateIfInstanceOf(e, DatasetRecordException.class);
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException(e, "Failed to append %s to %s", entity, this.appender);
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Failed to append " + entity + " to " + this.appender, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        try {
            if (ReaderWriterState.NEW.equals((Object)this.state) || ReaderWriterState.CLOSED.equals((Object)this.state)) {
                return;
            }
            if (!ReaderWriterState.ERROR.equals((Object)this.state)) {
                try {
                    this.appender.close();
                }
                catch (RuntimeException e) {
                    throw new DatasetOperationException(e, "Failed to close appender %s", this.appender);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Failed to close appender " + this.appender, e);
                }
            }
            if (this.count > 0 && (this.flushed || ReaderWriterState.OPEN.equals((Object)this.state))) {
                try {
                    if (!this.fs.rename(this.tempPath, this.finalPath)) {
                        throw new DatasetOperationException("Failed to move %s to %s", this.tempPath, this.finalPath);
                    }
                }
                catch (RuntimeException e) {
                    throw new DatasetOperationException(e, "Failed to commit %s", this.finalPath);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Failed to commit " + this.finalPath, e);
                }
                LOG.debug("Committed {} for appender {} ({} entities)", new Object[]{this.finalPath, this.appender, this.count});
            } else {
                try {
                    if (!this.fs.delete(this.tempPath, true)) {
                        throw new DatasetOperationException("Failed to delete %s", this.tempPath);
                    }
                }
                catch (RuntimeException e) {
                    throw new DatasetOperationException(e, "Failed to remove temporary file %s", this.tempPath);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Failed to remove temporary file " + this.tempPath, e);
                }
                LOG.debug("Discarded {} ({} entities)", (Object)this.tempPath, (Object)this.count);
            }
            try {
                this.appender.cleanup();
            }
            catch (IOException e) {
                throw new DatasetIOException("Failed to clean up " + this.appender, e);
            }
        }
        finally {
            this.state = ReaderWriterState.CLOSED;
        }
    }

    @Override
    public final boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    private static String uniqueFilename(Format format) {
        return UUID.randomUUID() + "." + format.getExtension();
    }

    private static Path tempFilename(Path location) {
        return new Path(location.getParent(), "." + location.getName() + ".tmp");
    }

    @VisibleForTesting
    <E> FileAppender<E> newAppender(Path temp) {
        Format format = this.descriptor.getFormat();
        if (Formats.PARQUET.equals(format)) {
            if (DescriptorUtil.isDisabled("kite.parquet.non-durable-writes", this.descriptor)) {
                return new DurableParquetAppender(this.fs, temp, this.descriptor.getSchema(), this.conf, this.descriptor.getCompressionType());
            }
            return new ParquetAppender(this.fs, temp, this.descriptor.getSchema(), this.conf, this.descriptor.getCompressionType());
        }
        if (Formats.AVRO.equals(format)) {
            return new AvroAppender(this.fs, temp, this.descriptor.getSchema(), this.descriptor.getCompressionType());
        }
        if (Formats.CSV.equals(format) && DescriptorUtil.isEnabled("kite.allow.csv", this.descriptor)) {
            return new CSVAppender(this.fs, temp, this.descriptor);
        }
        this.state = ReaderWriterState.ERROR;
        throw new UnknownFormatException("Unknown format " + this.descriptor);
    }

    static <E> FileSystemWriter<E> newWriter(FileSystem fs, Path path, DatasetDescriptor descriptor) {
        Format format = descriptor.getFormat();
        if (Formats.PARQUET.equals(format)) {
            if (DescriptorUtil.isDisabled("kite.parquet.non-durable-writes", descriptor)) {
                return new IncrementalWriter(fs, path, descriptor);
            }
            return new FileSystemWriter<E>(fs, path, descriptor);
        }
        if (Formats.AVRO.equals(format) || Formats.CSV.equals(format)) {
            return new IncrementalWriter(fs, path, descriptor);
        }
        return new FileSystemWriter<E>(fs, path, descriptor);
    }

    public RecordWriter<E, Void> asRecordWriter() {
        return new KiteRecordWriter();
    }

    private class KiteRecordWriter
    extends RecordWriter<E, Void> {
        private KiteRecordWriter() {
        }

        public void write(E e, Void aVoid) throws IOException, InterruptedException {
            FileSystemWriter.this.write(e);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            FileSystemWriter.this.close();
        }
    }

    static class IncrementalWriter<E>
    extends FileSystemWriter<E>
    implements Flushable,
    Syncable {
        private IncrementalWriter(FileSystem fs, Path path, DatasetDescriptor descriptor) {
            super(fs, path, descriptor);
        }

        @Override
        public void flush() {
            Preconditions.checkState(this.isOpen(), "Attempt to flush a writer in state:%s", new Object[]{this.state});
            try {
                this.appender.flush();
                this.flushed = true;
            }
            catch (RuntimeException e) {
                this.state = ReaderWriterState.ERROR;
                throw new DatasetOperationException(e, "Failed to flush appender %s", this.appender);
            }
            catch (IOException e) {
                this.state = ReaderWriterState.ERROR;
                throw new DatasetIOException("Failed to flush appender " + this.appender, e);
            }
        }

        @Override
        public void sync() {
            Preconditions.checkState(this.isOpen(), "Attempt to sync a writer in state:%s", new Object[]{this.state});
            try {
                this.appender.sync();
                this.flushed = true;
            }
            catch (RuntimeException e) {
                this.state = ReaderWriterState.ERROR;
                throw new DatasetOperationException(e, "Failed to sync appender %s", this.appender);
            }
            catch (IOException e) {
                this.state = ReaderWriterState.ERROR;
                throw new DatasetIOException("Failed to sync appender " + this.appender, e);
            }
        }
    }

    static interface FileAppender<E>
    extends java.io.Flushable,
    Closeable {
        public void open() throws IOException;

        public void append(E var1) throws IOException;

        public void sync() throws IOException;

        public void cleanup() throws IOException;
    }
}

