/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.rcfile;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public final class SingleStreamFileSystem
extends FileSystem {
    private final FSDataInputStream inputStream;
    private final Path path;
    private final FileStatus fileStatus;

    public SingleStreamFileSystem(InputStream inputStream, Path path) throws IOException {
        this.inputStream = new FSDataInputStream((InputStream)new ForwardOnlySeekable(inputStream));
        this.path = path;
        this.fileStatus = new FileStatus(Long.MAX_VALUE, false, 0, 0L, 0L, path);
    }

    public URI getUri() {
        throw new UnsupportedOperationException("not implemented!");
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (f.equals((Object)this.path)) {
            return this.inputStream;
        }
        throw new UnsupportedOperationException("Path " + f.getName() + " is not found");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException("not implemented!");
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException("not implemented!");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        if (this.path.equals((Object)f)) {
            return this.fileStatus;
        }
        throw new UnsupportedOperationException("Path " + f.getName() + " is not found");
    }

    public boolean delete(Path path) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    private static final class ForwardOnlySeekableInputStream {
        private final InputStream in;
        private long pos = 0L;

        public ForwardOnlySeekableInputStream(InputStream in) {
            this.in = in;
        }

        public long tell() throws IOException {
            return this.pos;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        public long length() throws IOException {
            throw new UnsupportedOperationException("Random access is not supported");
        }

        public void seek(long p) throws IOException {
            long todo = p - this.pos;
            if (todo < 0L) {
                throw new UnsupportedOperationException("Seeking backwards is not supported");
            }
            this.skip(todo);
        }

        private long skip(long len) throws IOException {
            long todo = len = Math.max(0L, len);
            while (todo > 0L) {
                long ret = this.in.skip(todo);
                if (ret == 0L) {
                    int b = this.in.read();
                    if (b == -1) {
                        throw new EOFException("Premature EOF from inputStream after skipping " + (len - todo) + " byte(s).");
                    }
                    ret = 1L;
                }
                todo -= ret;
                this.pos += ret;
            }
            return len;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class ForwardOnlySeekable
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private ForwardOnlySeekableInputStream fosInputStream;

        public ForwardOnlySeekable(InputStream inputStream) {
            this.fosInputStream = new ForwardOnlySeekableInputStream(inputStream);
        }

        public void seek(long pos) throws IOException {
            this.fosInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.fosInputStream.tell();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.fosInputStream.read(b, 0, 1);
            int ret = len == -1 ? -1 : b[0] & 0xFF;
            return ret;
        }
    }
}

