/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetailResponse;
import org.knowm.xchange.binance.dto.account.AssetDividendResponse;
import org.knowm.xchange.binance.dto.account.AssetDribbletLogResponse;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.DepositList;
import org.knowm.xchange.binance.dto.account.TransferHistoryResponse;
import org.knowm.xchange.binance.dto.account.TransferSubUserHistory;
import org.knowm.xchange.binance.dto.account.WapiResponse;
import org.knowm.xchange.binance.dto.account.WithdrawList;
import org.knowm.xchange.binance.dto.account.WithdrawRequest;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;

public class BinanceAccountServiceRaw
extends BinanceBaseService {
    public BinanceAccountServiceRaw(BinanceExchange exchange, BinanceAuthenticated binance, ResilienceRegistries resilienceRegistries) {
        super(exchange, binance, resilienceRegistries);
    }

    public BinanceAccountInformation account() throws BinanceException, IOException {
        return (BinanceAccountInformation)this.decorateApiCall(() -> this.binance.account(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public String withdraw(String asset, String address, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(asset, address, amount, name);
    }

    public String withdraw(String asset, String address, String addressTag, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(asset, address, addressTag, amount, name);
    }

    private String withdraw(String asset, String address, BigDecimal amount, String name) throws IOException, BinanceException {
        WithdrawRequest result = (WithdrawRequest)this.decorateApiCall(() -> this.binance.withdraw(asset, address, null, amount, name, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdraw", "nonIdempotenteCallsBase")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
        this.checkWapiResponse(result);
        return result.getData();
    }

    private String withdraw(String asset, String address, String addressTag, BigDecimal amount, String name) throws IOException, BinanceException {
        WithdrawRequest result = (WithdrawRequest)this.decorateApiCall(() -> this.binance.withdraw(asset, address, addressTag, amount, name, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdraw", "nonIdempotenteCallsBase")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
        this.checkWapiResponse(result);
        return result.getData();
    }

    public DepositAddress requestDepositAddress(Currency currency) throws IOException {
        return (DepositAddress)this.decorateApiCall(() -> this.binance.depositAddress(BinanceAdapters.toSymbol(currency), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositAddress")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public AssetDetailResponse requestAssetDetail() throws IOException {
        return (AssetDetailResponse)this.decorateApiCall(() -> this.binance.assetDetail(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDetail")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<DepositList.BinanceDeposit> depositHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        DepositList result = (DepositList)this.decorateApiCall(() -> this.binance.depositHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return this.checkWapiResponse(result);
    }

    public List<WithdrawList.BinanceWithdraw> withdrawHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        WithdrawList result = (WithdrawList)this.decorateApiCall(() -> this.binance.withdrawHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdrawHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return this.checkWapiResponse(result);
    }

    public AssetDribbletLogResponse.AssetDribbletLogResults getAssetDribbletLog() throws BinanceException, IOException {
        return ((AssetDribbletLogResponse)this.decorateApiCall(() -> this.binance.userAssetDribbletLog(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("userAssetDribbletLog")).withRateLimiter(this.rateLimiter("requestWeight")).call()).getData();
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(Long startTime, Long endTime) throws BinanceException, IOException {
        return this.getAssetDividend("", startTime, endTime);
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return ((AssetDividendResponse)this.decorateApiCall(() -> this.binance.assetDividend(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDividend")).withRateLimiter(this.rateLimiter("requestWeight")).call()).getData();
    }

    public List<TransferHistoryResponse.TransferHistory> getTransferHistory(String email, Long startTime, Long endTime, Integer page, Integer limit) throws BinanceException, IOException {
        return ((TransferHistoryResponse)this.decorateApiCall(() -> this.binance.transferHistory(email, startTime, endTime, page, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call()).getData();
    }

    public List<TransferSubUserHistory> getSubUserHistory(String asset, Integer type, Long startTime, Long endTime, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.transferSubUserHistory(asset, type, startTime, endTime, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferSubUserHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    private <T> T checkWapiResponse(WapiResponse<T> result) {
        if (!result.success) {
            BinanceException exception;
            try {
                exception = (BinanceException)((Object)new ObjectMapper().readValue(result.msg, BinanceException.class));
            }
            catch (Throwable e) {
                exception = new BinanceException(-1, result.msg);
            }
            throw exception;
        }
        return result.getData();
    }
}

