/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;

public class BinanceTradeServiceRaw
extends BinanceBaseService {
    protected BinanceTradeServiceRaw(BinanceExchange exchange, BinanceAuthenticated binance, ResilienceRegistries resilienceRegistries) {
        super(exchange, binance, resilienceRegistries);
    }

    public List<BinanceOrder> openOrders() throws BinanceException, IOException {
        return this.openOrders(null);
    }

    public List<BinanceOrder> openOrders(CurrencyPair pair) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.openOrders(Optional.ofNullable(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(pair)).call();
    }

    public BinanceNewOrder newOrder(CurrencyPair pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, BigDecimal icebergQty) throws IOException, BinanceException {
        return (BinanceNewOrder)this.decorateApiCall(() -> this.binance.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, price, newClientOrderId, stopPrice, icebergQty, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newOrder", "nonIdempotenteCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("ordersPerDay")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void testNewOrder(CurrencyPair pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, BigDecimal icebergQty) throws IOException, BinanceException {
        this.decorateApiCall(() -> this.binance.testNewOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, price, newClientOrderId, stopPrice, icebergQty, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("testNewOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceOrder orderStatus(CurrencyPair pair, long orderId, String origClientOrderId) throws IOException, BinanceException {
        return (BinanceOrder)this.decorateApiCall(() -> this.binance.orderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("orderStatus")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceCancelledOrder cancelOrder(CurrencyPair pair, long orderId, String origClientOrderId, String newClientOrderId) throws IOException, BinanceException {
        return (BinanceCancelledOrder)this.decorateApiCall(() -> this.binance.cancelOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, newClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceCancelledOrder> cancelAllOpenOrders(CurrencyPair pair) throws IOException, BinanceException {
        return (List)this.decorateApiCall(() -> this.binance.cancelAllOpenOrders(BinanceAdapters.toSymbol(pair), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelAllOpenOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceOrder> allOrders(CurrencyPair pair, Long orderId, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.allOrders(BinanceAdapters.toSymbol(pair), orderId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("allOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceTrade> myTrades(CurrencyPair pair, Integer limit, Long startTime, Long endTime, Long fromId) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.myTrades(BinanceAdapters.toSymbol(pair), limit, startTime, endTime, fromId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myTrades")).withRateLimiter(this.rateLimiter("requestWeight"), this.myTradesPermits(limit)).call();
    }

    public BinanceListenKey startUserDataStream() throws IOException {
        return (BinanceListenKey)this.decorateApiCall(() -> this.binance.startUserDataStream(this.apiKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void keepAliveDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.keepAliveUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void closeDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.closeUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected int openOrdersPermits(CurrencyPair pair) {
        return pair != null ? 1 : 40;
    }

    protected int myTradesPermits(Integer limit) {
        if (limit != null && limit > 500) {
            return 10;
        }
        return 5;
    }
}

