/*
 * Decompiled with CFR 0.152.
 */
package com.sun.maven.junit;

import com.sun.maven.junit.AntXmlFormatter;
import com.sun.maven.junit.FailedTest;
import com.sun.maven.junit.JUnitSharingClassLoader;
import com.sun.maven.junit.ProgressReporter;
import com.sun.maven.junit.Result;
import com.sun.maven.junit.TestCaseRunner;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTestCaseRunner
implements TestCaseRunner,
Serializable {
    private final File reportDirectory;
    private transient ClassLoader cl;
    private transient PrintStream progress;
    private AntXmlFormatter formatter;
    private static final Test EMPTY = new TestSuite();
    private static final long serialVersionUID = 1L;

    public LocalTestCaseRunner(File reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    @Override
    public void setUp(List<URL> classpath, boolean quiet) {
        this.cl = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), (ClassLoader)new JUnitSharingClassLoader(null, this.getClass().getClassLoader()));
        this.progress = System.out;
        if (quiet) {
            this.redirectToDevNull();
        }
        this.formatter = new AntXmlFormatter(XMLJUnitResultFormatter.class, this.reportDirectory);
    }

    @Override
    public Result runTestCase(String fileName) {
        return this.runTestCase(fileName, null);
    }

    public Result runTestCase(String fileName, String methodName) {
        return Result.from(this.runTests(this.buildTestCase(fileName), this.progress));
    }

    public void redirectToDevNull() {
        System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
        System.setErr(new PrintStream((OutputStream)new NullOutputStream()));
    }

    public Test buildTestCase(String fileName) {
        int index = fileName.indexOf(35);
        String methodName = null;
        if (index >= 0) {
            methodName = fileName.substring(index + 1, fileName.length());
            return this.buildMethodTestCase(fileName.substring(0, index), methodName);
        }
        return this.buildMethodTestCase(fileName, methodName);
    }

    private Test buildMethodTestCase(String fileName, String methodName) {
        String className = this.toClassName(fileName);
        try {
            Class<?> c = this.cl.loadClass(className);
            if (!this.isTest(c)) {
                return EMPTY;
            }
            try {
                Method m = c.getDeclaredMethod("suite", new Class[0]);
                if (Modifier.isStatic(m.getModifiers())) {
                    try {
                        return (Test)m.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        return new FailedTest(e);
                    }
                    catch (InvocationTargetException e) {
                        return new FailedTest(e);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (TestCase.class.isAssignableFrom(c)) {
                if (methodName == null) {
                    return new TestSuite(c);
                }
                TestSuite test = new TestSuite();
                for (Method m : c.getMethods()) {
                    if (!SelectorUtils.match((String)methodName, (String)m.getName())) continue;
                    test.addTest(TestSuite.createTest(c, (String)m.getName()));
                }
                return test;
            }
            return new JUnit4TestAdapter(c);
        }
        catch (ClassNotFoundException e) {
            return new FailedTest(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult runTests(Test all, PrintStream report) {
        TestResult tr = new TestResult();
        tr.addListener((TestListener)this.formatter);
        tr.addListener((TestListener)new ProgressReporter(report));
        Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        t.setContextClassLoader(this.cl);
        try {
            all.run(tr);
        }
        finally {
            t.setContextClassLoader(old);
        }
        return tr;
    }

    @Override
    public void tearDown() {
        this.formatter.close();
    }

    protected boolean isTest(Class c) {
        return !Modifier.isAbstract(c.getModifiers());
    }

    protected String toClassName(String name) {
        name = name.substring(0, name.length() - ".class".length());
        return name.replace('/', '.').replace('\\', '.');
    }

    public TestCaseRunner copyTo(Channel channel) throws IOException, InterruptedException {
        return (TestCaseRunner)channel.call((Callable)new Callable<TestCaseRunner, IOException>(){

            public TestCaseRunner call() throws IOException {
                return (TestCaseRunner)Channel.current().export(TestCaseRunner.class, (Object)LocalTestCaseRunner.this);
            }
        });
    }
}

