/*
 * Decompiled with CFR 0.152.
 */
package com.sun.maven.junit;

import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class ProgressReporter
implements TestListener {
    private final PrintStream report;
    private int width;

    public ProgressReporter(PrintStream report) {
        this.report = report;
    }

    public void addError(Test test, Throwable t) {
        this.report.println("FAILURE: " + test.toString());
        t.printStackTrace(this.report);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addError(test, (Throwable)t);
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
        this.letter('.');
    }

    private synchronized void letter(char ch) {
        this.report.print(ch);
        if (this.width++ > 72) {
            this.report.println();
            this.width = 0;
        }
    }
}

