/*
 * Decompiled with CFR 0.152.
 */
package com.sun.maven.junit;

import hudson.remoting.ProxyException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements Serializable {
    public final int totalRun;
    public final List<Failure> failures = new ArrayList<Failure>();
    public final List<Failure> errors = new ArrayList<Failure>();
    public static final Result ZERO = new Result(0);
    private static final long serialVersionUID = 1L;

    public Result(int totalRun) {
        this.totalRun = totalRun;
    }

    public Result add(Result that) {
        Result r = new Result(this.totalRun + that.totalRun);
        r.failures.addAll(this.failures);
        r.failures.addAll(that.failures);
        r.errors.addAll(this.errors);
        r.errors.addAll(that.errors);
        return r;
    }

    public static Result add(Result ... results) {
        Result r = results[0];
        for (int i = 1; i < results.length; ++i) {
            r = r.add(results[i]);
        }
        return r;
    }

    public static Result from(TestResult tr) {
        Result r = new Result(tr.runCount());
        Result.copyTo(tr.errors(), r.errors);
        Result.copyTo(tr.failures(), r.failures);
        return r;
    }

    public static Result fromFailure(Failure f) {
        Result r = new Result(1);
        r.failures.add(f);
        return r;
    }

    public boolean isSuccess() {
        return this.failures.isEmpty() && this.errors.isEmpty();
    }

    public TestResult toTestResult() {
        TestResult r = new TestResult();
        r.startTest(new Test(){

            public int countTestCases() {
                return Result.this.totalRun;
            }

            public void run(TestResult result) {
            }
        });
        for (Failure f : this.failures) {
            r.addError((Test)f, f.cause);
        }
        for (Failure f : this.errors) {
            r.addError((Test)f, f.cause);
        }
        return r;
    }

    private static void copyTo(Enumeration<TestFailure> e, List<Failure> dest) {
        while (e.hasMoreElements()) {
            dest.add(new Failure(e.nextElement()));
        }
    }

    public static class Failure
    implements Serializable,
    Test {
        public final String name;
        public final Throwable cause;
        private static final long serialVersionUID = 1L;

        public Failure(String name, Throwable cause) {
            this.name = name;
            this.cause = cause;
        }

        public Failure(TestFailure f) {
            this.name = f.failedTest().toString();
            this.cause = new ProxyException(f.thrownException());
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult result) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.name;
        }
    }
}

