/*
 * Decompiled with CFR 0.152.
 */
package com.sun.maven.junit;

import com.sun.maven.junit.ClasspathBuilder;
import com.sun.maven.junit.CopyThread;
import com.sun.maven.junit.LocalTestCaseRunner;
import com.sun.maven.junit.Result;
import com.sun.maven.junit.TestCaseRunner;
import hudson.remoting.Channel;
import hudson.remoting.Launcher;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.junit.ParallelTestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractMojo {
    protected MavenProject project;
    protected List<String> classpathElements;
    protected boolean testFailureIgnore;
    protected boolean fork = false;
    protected int concurrency = 1;
    protected String debugForkedProcess;
    protected String test = "*Test";
    protected boolean quiet;
    protected String argLine;
    protected Properties systemProperties = new Properties();
    protected boolean skipTests;
    private File reportsDirectory;
    private int timeout = 0;
    private List<String> excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        this.normalizeParameters();
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeLocal();
        }
    }

    private void normalizeParameters() {
        if (this.concurrency < 0) {
            this.concurrency = -Runtime.getRuntime().availableProcessors() * this.concurrency;
        }
        this.concurrency = Math.max(this.concurrency, 1);
        if ("true".equals(this.debugForkedProcess)) {
            this.debugForkedProcess = "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLocal() throws MojoExecutionException {
        PrintStream progress = System.out;
        try {
            LocalTestCaseRunner runner = this.createTestCaseRunner();
            runner.setUp(this.makeClassPath(), this.quiet);
            try {
                TestSuite all = this.buildTestSuite(runner, (TestSuite)(this.concurrency > 1 ? new ParallelTestSuite(this.concurrency) : new TestSuite()));
                long startTime = System.currentTimeMillis();
                TestResult r = runner.runTests((Test)all, progress);
                this.printResult(r, System.currentTimeMillis() - startTime);
            }
            finally {
                runner.tearDown();
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to execute JUnit tests", (Exception)e);
        }
    }

    protected LocalTestCaseRunner createTestCaseRunner() {
        return new LocalTestCaseRunner(this.getReportDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeForked() throws MojoExecutionException, MojoFailureException {
        try {
            final ExecutorService remoteOps = Executors.newCachedThreadPool();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Port {
                Channel channel;
                TestCaseRunner runner;
                final /* synthetic */ ExecutorService val$remoteOps;

                Port() throws IOException, InterruptedException {
                    this.val$remoteOps = executorService;
                    this.channel = TestMojo.this.fork(System.out, this.val$remoteOps);
                    this.runner = TestMojo.this.createTestCaseRunner().copyTo(this.channel);
                    this.runner.setUp(TestMojo.this.makeClassPath(), TestMojo.this.quiet);
                }
            }
            final Set<Port> ports = Collections.synchronizedSet(new HashSet());
            final ThreadLocal port4thread = new ThreadLocal();
            long startTime = System.currentTimeMillis();
            try {
                ExecutorService testRunners = Executors.newFixedThreadPool(this.concurrency);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Task
                implements Callable<Result> {
                    final String testClassFile;
                    final Future<Result> future;
                    volatile long startTime;

                    Task(String testClassFile, ExecutorService es) {
                        this.testClassFile = testClassFile;
                        this.future = es.submit(this);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Result call() throws Exception {
                        Port p = (Port)port4thread.get();
                        if (p == null) {
                            p = new Port(TestMojo.this, remoteOps);
                            port4thread.set(p);
                            ports.add(p);
                        }
                        this.startTime = System.currentTimeMillis();
                        String oldName = Thread.currentThread().getName();
                        try {
                            int index = TestMojo.this.test.indexOf(35);
                            if (index >= 0) {
                                String methodName = TestMojo.this.test.substring(index + 1, TestMojo.this.test.length());
                                Thread.currentThread().setName(oldName + " : executing test " + this.testClassFile + "#" + methodName);
                                Result result = p.runner.runTestCase(this.testClassFile + "#" + methodName);
                                return result;
                            }
                            Thread.currentThread().setName(oldName + " : executing test " + this.testClassFile);
                            Result result = p.runner.runTestCase(this.testClassFile);
                            return result;
                        }
                        finally {
                            Thread.currentThread().setName(oldName);
                        }
                    }
                }
                ArrayList<Task> jobs = new ArrayList<Task>();
                for (String testClassFile : this.scanTestClasses().getIncludedFiles()) {
                    jobs.add(new Task(testClassFile, testRunners));
                }
                Result r = Result.ZERO;
                String oldName = Thread.currentThread().getName();
                for (Task f : jobs) {
                    try {
                        Thread.currentThread().setName(oldName + " : waiting for " + f.testClassFile);
                        while (true) {
                            long timeoutMillis = -1L;
                            if (this.timeout > 0) {
                                timeoutMillis = f.startTime > 0L ? Math.max(0L, System.currentTimeMillis() - timeoutMillis) : (long)(this.timeout * 1000);
                            }
                            try {
                                r = r.add(timeoutMillis == -1L ? f.future.get() : f.future.get(timeoutMillis, TimeUnit.MILLISECONDS));
                            }
                            catch (TimeoutException e) {
                                if (f.startTime <= 0L || System.currentTimeMillis() - f.startTime <= (long)(this.timeout * 1000)) continue;
                                r.add(Result.fromFailure(new Result.Failure("Test " + f.testClassFile + " timed out", e)));
                                f.future.cancel(true);
                            }
                            break;
                        }
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        throw new MojoExecutionException("Failed to run a test", (Exception)e);
                    }
                }
                Thread.currentThread().setName(oldName);
                this.printResult(r.toTestResult(), System.currentTimeMillis() - startTime);
                if (!r.isSuccess() && !this.testFailureIgnore) {
                    String msg = String.format("Tests run: %d,  Failures: %d,  Errors: %d", r.totalRun, r.failures.size(), r.errors.size());
                    throw new MojoExecutionException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    Iterator<Port> i$ = ports.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            remoteOps.shutdownNow();
                            throw throwable;
                        }
                        Port p = i$.next();
                        p.runner.tearDown();
                        p.channel.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                Iterator<Port> i$ = ports.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        remoteOps.shutdownNow();
                        return;
                    }
                    Port p = i$.next();
                    p.runner.tearDown();
                    p.channel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Failed to execute JUnit tests", (Exception)e);
        }
    }

    private void printResult(TestResult r, long totalTime) {
        ResultPrinter printer = new ResultPrinter(System.out);
        try {
            Method m = printer.getClass().getDeclaredMethod("print", TestResult.class, Long.TYPE);
            m.setAccessible(true);
            m.invoke((Object)printer, r, totalTime);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public Channel fork(OutputStream output, ExecutorService executors) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress("localhost", 0));
        int port = serverSocket.getLocalPort();
        ArrayList<String> args = new ArrayList<String>();
        args.add(new File(System.getProperty("java.home"), "bin/java").getAbsolutePath());
        ClasspathBuilder cb = new ClasspathBuilder();
        cb.addJarOf(Channel.class).addJarOf(TestCase.class);
        this.addTokenized(args, this.debugForkedProcess);
        this.addTokenized(args, this.argLine);
        for (Map.Entry<Object, Object> e : this.systemProperties.entrySet()) {
            args.add("-D" + e.getKey() + '=' + e.getValue());
        }
        args.add("-cp");
        args.add(cb.toString());
        args.add(Launcher.class.getName());
        args.add("-connectTo");
        args.add("localhost:" + port);
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        final Process proc = pb.start();
        proc.getOutputStream().close();
        final CopyThread t1 = new CopyThread("stream copy thread", proc.getInputStream(), output);
        t1.start();
        Socket s = serverSocket.accept();
        serverSocket.close();
        return new Channel("Channel to child process port:" + port, executors, new BufferedInputStream((InputStream)new SocketInputStream(s)), new BufferedOutputStream((OutputStream)new SocketOutputStream(s))){

            protected synchronized void terminate(IOException e) {
                super.terminate(e);
                proc.destroy();
                t1.interrupt();
            }

            public synchronized void close() throws IOException {
                super.close();
                try {
                    proc.waitFor();
                    t1.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    private void addTokenized(List<String> args, String line) {
        if (line == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(line);
        while (tokens.hasMoreTokens()) {
            args.add(tokens.nextToken());
        }
    }

    private File getReportDirectory() {
        this.reportsDirectory.mkdirs();
        return this.reportsDirectory;
    }

    private TestSuite buildTestSuite(LocalTestCaseRunner r, TestSuite testSuite) throws MojoExecutionException {
        int index = this.test.indexOf(35);
        String methodName = null;
        if (index >= 0) {
            methodName = this.test.substring(index + 1, this.test.length());
        }
        for (String name : this.scanTestClasses().getIncludedFiles()) {
            testSuite.addTest(r.buildTestCase(name + (methodName == null ? "" : "#" + methodName)));
        }
        return testSuite;
    }

    private DirectoryScanner scanTestClasses() {
        FileSet fs = new FileSet();
        fs.setDir(this.getTestOutputDirectory());
        String classNamesPattern = this.test;
        if (this.test.contains("#")) {
            classNamesPattern = this.test.substring(0, this.test.indexOf(35));
        }
        fs.setIncludes("**/" + classNamesPattern.replace('.', '/') + ".class");
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                fs.setExcludes(exclude);
            }
        }
        return fs.getDirectoryScanner(new Project());
    }

    private File getTestOutputDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }
}

