/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyFacet;

public class ResourceBundle {
    private final String baseName;
    private final Map<String, Properties> resources = new ConcurrentHashMap<String, Properties>();
    private static final Map<String, String> ISO639_MAP = new HashMap<String, String>();

    public ResourceBundle(String baseName) {
        this.baseName = baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String format(Locale locale, String key, Object ... args) {
        String str = this.getFormatString(locale, key);
        if (str == null) {
            return key;
        }
        return MessageFormat.format(str, args);
    }

    public String getFormatString(Locale locale, String key) {
        String[] suffixes = this.toStrings(locale);
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= suffixes.length) continue block0;
                String suffix = suffixes[i];
                String msg = this.get(suffix).getProperty(key);
                if (msg != null && msg.length() > 0) {
                    return msg;
                }
                int idx = suffix.lastIndexOf(95);
                if (idx < 0) {
                    return null;
                }
                suffixes[i] = suffix.substring(0, idx);
                ++i;
            }
            break;
        }
    }

    public String getFormatStringWithoutDefaulting(Locale locale, String key) {
        for (String s : this.toStrings(locale)) {
            String msg = this.get(s).getProperty(key);
            if (msg == null || msg.length() <= 0) continue;
            return msg;
        }
        return null;
    }

    private String[] toStrings(Locale l) {
        String v = ISO639_MAP.get(l.getLanguage());
        if (v == null) {
            return new String[]{'_' + l.toString()};
        }
        return new String[]{'_' + l.toString(), '_' + v + l.toString().substring(2)};
    }

    protected void clearCache() {
        this.resources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties get(String key) {
        Properties props;
        if (!MetaClass.NO_CACHE && (props = this.resources.get(key)) != null) {
            return props;
        }
        props = new Properties();
        String url = this.baseName + key + ".properties";
        InputStream in = null;
        try {
            in = new URL(url).openStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (in != null) {
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new Error("Failed to load " + url, e);
            }
        }
        this.resources.put(key, this.wrapUp(key.length() > 0 ? key.substring(1) : "", props));
        return props;
    }

    protected Properties wrapUp(String locale, Properties props) {
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundle that = (ResourceBundle)o;
        return this.baseName.equals(that.baseName);
    }

    public int hashCode() {
        return this.baseName.hashCode();
    }

    public static ResourceBundle load(URL jellyUrl) {
        return ResourceBundle.load(jellyUrl.toExternalForm());
    }

    public static ResourceBundle load(String jellyUrl) {
        if (jellyUrl.endsWith(".jelly")) {
            jellyUrl = jellyUrl.substring(0, jellyUrl.length() - ".jelly".length());
        }
        JellyFacet facet = (JellyFacet)WebApp.getCurrent().getFacet(JellyFacet.class);
        return facet.resourceBundleFactory.create(jellyUrl);
    }

    static {
        ISO639_MAP.put("iw", "he");
        ISO639_MAP.put("ji", "yi");
        ISO639_MAP.put("in", "id");
    }
}

