/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.CustomTagLibrary;
import org.kohsuke.stapler.jelly.StaplerTagLibrary;
import org.kohsuke.stapler.jelly.ThisTagLibrary;

public class JellyClassLoaderTearOff {
    private final MetaClassLoader owner;
    private volatile WeakReference<LoadingCache<String, TagLibrary>> taglibs;
    public static ExpressionFactory EXPRESSION_FACTORY = new JexlExpressionFactory();
    private static final JellyContext ROOT_CONTEXT = new CustomJellyContext();
    private static final TagLibrary NO_SUCH_TAGLIBRARY = new TagLibrary(){};

    public JellyClassLoaderTearOff(MetaClassLoader owner) {
        this.owner = owner;
    }

    public TagLibrary getTagLibrary(String nsUri) {
        TagLibrary tl;
        LoadingCache m = null;
        if (this.taglibs != null) {
            m = (LoadingCache)this.taglibs.get();
        }
        if (m == null) {
            m = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TagLibrary>(){

                public TagLibrary load(String nsUri) {
                    TagLibrary tl;
                    if (((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.parent != null && (tl = ((JellyClassLoaderTearOff)((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.parent.loadTearOff(JellyClassLoaderTearOff.class)).getTagLibrary(nsUri)) != null) {
                        return tl;
                    }
                    String taglibBasePath = JellyClassLoaderTearOff.this.trimHeadSlash(nsUri);
                    try {
                        URL res = ((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.loader.getResource(taglibBasePath + "/taglib");
                        if (res != null) {
                            return new CustomTagLibrary(JellyClassLoaderTearOff.this.createContext(), ((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.loader, nsUri, taglibBasePath);
                        }
                    }
                    catch (IllegalArgumentException res) {
                        // empty catch block
                    }
                    if (nsUri.startsWith("this:")) {
                        try {
                            return new ThisTagLibrary(EXPRESSION_FACTORY.createExpression(nsUri.substring(5)));
                        }
                        catch (JellyException e) {
                            throw new IllegalArgumentException("Illegal expression in the URI: " + nsUri, e);
                        }
                    }
                    if (nsUri.equals("jelly:stapler")) {
                        return new StaplerTagLibrary();
                    }
                    return NO_SUCH_TAGLIBRARY;
                }
            });
            this.taglibs = new WeakReference<LoadingCache>(m);
        }
        if ((tl = (TagLibrary)m.getUnchecked((Object)nsUri)) == NO_SUCH_TAGLIBRARY) {
            return null;
        }
        return tl;
    }

    private String trimHeadSlash(String nsUri) {
        if (nsUri.startsWith("/")) {
            return nsUri.substring(1);
        }
        return nsUri;
    }

    public JellyContext createContext() {
        CustomJellyContext context = new CustomJellyContext(ROOT_CONTEXT);
        context.setClassLoader(this.owner.loader);
        context.setExportLibraries(false);
        return context;
    }
}

