/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.mockito.spring.factory;

import java.util.HashMap;
import java.util.Map;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFactoryBean<T>
implements FactoryBean<T> {
    private Class<T> mockClass;
    private String beanId;
    private boolean useStaticMap;
    private T thisInstance;
    private static Map<String, Object> objectMap = new HashMap<String, Object>();

    public MockFactoryBean(Class<T> mockClass, String beanId, boolean useStaticMap) {
        this.mockClass = mockClass;
        this.beanId = beanId;
        this.useStaticMap = useStaticMap;
    }

    public Class<? extends T> getObjectType() {
        return this.mockClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public T getObject() throws Exception {
        if (this.useStaticMap) {
            Object instance = objectMap.get(this.beanId);
            if (instance == null) {
                instance = Mockito.mock(this.mockClass);
                objectMap.put(this.beanId, instance);
            }
            return (T)instance;
        }
        if (this.thisInstance == null) {
            this.thisInstance = Mockito.mock(this.mockClass);
        }
        return this.thisInstance;
    }
}

