/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ssl.SSLSocketVerifier;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDStartTLSConnectionFactory;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.HostnameVerifierAdapter;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundIDProvider
implements Provider<UnboundIDProviderConfig> {
    private UnboundIDProviderConfig config = new UnboundIDProviderConfig();

    public ProviderConnectionFactory<UnboundIDProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        LDAPConnectionOptions options;
        SSLSocketFactory factory = this.config.getSSLSocketFactory();
        if (factory == null && (cc.getUseStartTLS() || cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://"))) {
            if (cc.getSslConfig() != null && !cc.getSslConfig().isEmpty()) {
                TLSSocketFactory sf = new TLSSocketFactory();
                sf.setSslConfig(SslConfig.newSslConfig((SslConfig)cc.getSslConfig()));
                try {
                    sf.initialize();
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
                factory = sf;
            } else if (cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://")) {
                SSLUtil util = new SSLUtil();
                try {
                    factory = util.createSSLSocketFactory();
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if ((options = this.config.getConnectionOptions()) == null) {
            options = this.getDefaultLDAPConnectionOptions(cc);
        }
        AbstractProviderConnectionFactory cf = cc.getUseStartTLS() ? new UnboundIDStartTLSConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, factory, options) : new UnboundIDConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, factory, options);
        return cf;
    }

    protected SSLSocketFactory getHostnameVerifierSocketFactory(ConnectionConfig cc) {
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        return TLSSocketFactory.getHostnameVerifierFactory((SslConfig)cc.getSslConfig(), (String[])ldapUrl.getHostnames());
    }

    protected LDAPConnectionOptions getDefaultLDAPConnectionOptions(ConnectionConfig cc) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        if (cc.getConnectTimeout() != null) {
            options.setConnectTimeoutMillis((int)cc.getConnectTimeout().toMillis());
        }
        if (cc.getResponseTimeout() != null) {
            options.setResponseTimeoutMillis(cc.getResponseTimeout().toMillis());
        }
        Object verifier = cc.getSslConfig() != null && !cc.getSslConfig().isEmpty() ? (cc.getSslConfig().getHostnameVerifier() != null ? new HostnameVerifierAdapter(cc.getSslConfig().getHostnameVerifier()) : new DefaultHostnameVerifier()) : new DefaultHostnameVerifier();
        options.setSSLSocketVerifier(new SSLSocketVerifier((HostnameVerifier)verifier){
            private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            final /* synthetic */ HostnameVerifier val$verifier;
            {
                this.val$verifier = hostnameVerifier;
            }

            public void verifySSLSocket(String host, int port, SSLSocket sslSocket) throws LDAPException {
                block4: {
                    this.logger.trace("Verifying SSLSocket {} for host {} with verifier {}", new Object[]{sslSocket, host, this.val$verifier});
                    SSLSession session = sslSocket.getSession();
                    try {
                        session.getPeerCertificates();
                        if (this.val$verifier.verify(host, session)) break block4;
                        try {
                            sslSocket.close();
                        }
                        catch (IOException e) {
                            this.logger.debug("Error closing SSL socket", (Throwable)e);
                        }
                        throw new LDAPException(ResultCode.CONNECT_ERROR, "Hostname verification failed for " + host);
                    }
                    catch (SSLPeerUnverifiedException e) {
                        throw new LDAPException(ResultCode.CONNECT_ERROR, "Trust verification failed for " + host, (Throwable)e);
                    }
                }
            }
        });
        return options;
    }

    public UnboundIDProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(UnboundIDProviderConfig pc) {
        this.config = pc;
    }

    public UnboundIDProvider newInstance() {
        return new UnboundIDProvider();
    }
}

