/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import leap.lang.Objects2;

public class Args {
    public static void assertTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T notNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        return reference;
    }

    public static <T> T notNull(T reference, String name) {
        if (reference == null) {
            throw new IllegalArgumentException("argument '" + name + "' must not be null");
        }
        return reference;
    }

    public static String notEmpty(String s) {
        if (null == s || s.isEmpty()) {
            throw new IllegalArgumentException("Argument must not be null or empty");
        }
        return s;
    }

    public static String notEmpty(String s, String name) {
        if (null == s || s.isEmpty()) {
            throw new IllegalArgumentException("Argument '" + name + "' must not be null or empty");
        }
        return s;
    }

    public static <T> T notEmpty(T reference) {
        if (Objects2.isEmpty(reference)) {
            throw new IllegalArgumentException("argument must not be null or empty");
        }
        return reference;
    }

    public static <T> T notEmpty(T reference, String name) {
        if (Objects2.isEmpty(reference)) {
            throw new IllegalArgumentException("argument '" + name + "' must not be null or empty");
        }
        return reference;
    }

    protected Args() {
    }
}

