/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import leap.lang.Objects2;
import leap.lang.Strings;

public class Assert {
    public static void fail(String message) throws IllegalStateException {
        throw new IllegalStateException(message);
    }

    public static void fail(String errorMessageTemplate, Object ... errorMessageArgs) throws IllegalStateException {
        throw new IllegalStateException(Strings.format(errorMessageTemplate, errorMessageArgs));
    }

    public static <T> T notNull(T object) throws IllegalStateException {
        if (object == null) {
            throw new IllegalStateException("object must not be null");
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMessage) throws IllegalStateException {
        if (object == null) {
            throw new IllegalStateException(errorMessage);
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMessageTemplate, Object ... errorMessageArgs) throws IllegalStateException {
        if (object == null) {
            throw new IllegalStateException(Strings.format(errorMessageTemplate, errorMessageArgs));
        }
        return object;
    }

    public static <T> T isNull(T object) throws IllegalStateException {
        if (object != null) {
            throw new IllegalStateException("object must be null");
        }
        return object;
    }

    public static <T> T isNull(T object, String errorMessage) throws IllegalStateException {
        if (object != null) {
            throw new IllegalStateException(errorMessage);
        }
        return object;
    }

    public static <T> T isNull(T object, String errorMessageTemplate, Object ... errorMessageArgs) throws IllegalStateException {
        if (object != null) {
            throw new IllegalStateException(Strings.format(errorMessageTemplate, errorMessageArgs));
        }
        return object;
    }

    public static <T> T notEmpty(T object) throws IllegalStateException {
        if (Objects2.isEmpty(object)) {
            throw new IllegalStateException("The value cannot be null or empty");
        }
        return object;
    }

    public static <T> T notEmpty(T object, String errorMessage) throws IllegalStateException {
        if (Objects2.isEmpty(object)) {
            throw new IllegalStateException(errorMessage);
        }
        return object;
    }

    public static <T> T notEmpty(T object, String errorMessageTemplate, Object ... errorMessageArgs) throws IllegalStateException {
        if (Objects2.isEmpty(object)) {
            throw new IllegalStateException(Strings.format(errorMessageTemplate, errorMessageArgs));
        }
        return object;
    }

    public static void isTrue(boolean expression) throws IllegalStateException {
        Assert.isTrue(expression, "the expression must be true");
    }

    public static void isTrue(boolean expression, String message) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void isTrue(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(Strings.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void isFalse(boolean expression) throws IllegalStateException {
        Assert.isFalse(expression, "the expression must be false");
    }

    public static void isFalse(boolean expression, String message) throws IllegalStateException {
        if (expression) {
            throw new IllegalStateException(message);
        }
    }

    protected Assert() {
    }
}

