/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.Enumerables;
import leap.lang.New;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.beans.DynaBean;
import leap.lang.convert.Converts;
import leap.lang.exception.ObjectNotFoundException;

public class Beans {
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    public static final String IS_PREFIX = "is";

    public static boolean isSimpleProperty(Class<?> clazz) {
        Args.notNull(clazz, "class");
        return Classes.isSimpleValueType(clazz) || clazz.isArray() && Classes.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSetterMethod(String methodName) {
        return null != methodName && methodName.startsWith(SETTER_PREFIX) && methodName.length() > SETTER_PREFIX.length() && Character.isUpperCase(methodName.charAt(SETTER_PREFIX.length()));
    }

    public static boolean isGetterMethod(String methodName) {
        return null != methodName && methodName.startsWith(GETTER_PREFIX) && methodName.length() > GETTER_PREFIX.length() && Character.isUpperCase(methodName.charAt(GETTER_PREFIX.length()));
    }

    public static String extractPropertyFromSetter(String methodName) {
        String propName = methodName.substring(SETTER_PREFIX.length());
        if (propName.length() == 1) {
            return propName.toLowerCase();
        }
        return Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
    }

    public static String extraPropertyFromGetter(String methodName) {
        String propName = methodName.substring(GETTER_PREFIX.length());
        if (propName.length() == 1) {
            return propName.toLowerCase();
        }
        return Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
    }

    public static Map<String, Object> toMap(Object bean) {
        if (null == bean) {
            return new HashMap<String, Object>();
        }
        if (bean instanceof Map) {
            return (Map)bean;
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getProperties();
        }
        return BeanType.of(bean.getClass()).toMap(bean);
    }

    public static void copyProperties(Object from, Object to) {
        if (null == from || null == to) {
            return;
        }
        boolean toDyna = to instanceof DynaBean;
        if (toDyna) {
            DynaBean toDynaBean = (DynaBean)to;
            boolean fromDyna = from instanceof DynaBean;
            if (fromDyna) {
                for (Map.Entry<String, Object> entry : ((DynaBean)from).getProperties().entrySet()) {
                    toDynaBean.setProperty(entry.getKey(), entry.getValue());
                }
            } else {
                BeanType fromBeanType = BeanType.of(from.getClass());
                for (BeanProperty bp : fromBeanType.getProperties()) {
                    toDynaBean.setProperty(bp.getName(), bp.getValue(from));
                }
            }
        } else {
            BeanType toBeanType = BeanType.of(to.getClass());
            boolean fromDyna = from instanceof DynaBean;
            if (fromDyna) {
                DynaBean fromDynaBean = (DynaBean)from;
                for (BeanProperty bp : toBeanType.getProperties()) {
                    if (!bp.isWritable()) continue;
                    bp.setValue(to, fromDynaBean.getProperty(bp.getName()));
                }
            } else {
                BeanType fromBeanType = BeanType.of(from.getClass());
                for (BeanProperty toBp : toBeanType.getProperties()) {
                    BeanProperty fromBp;
                    if (!toBp.isWritable() || null == (fromBp = fromBeanType.tryGetProperty(toBp.getName()))) continue;
                    toBp.setValue(to, fromBp.getValue(from));
                }
            }
        }
    }

    public static Object getProperty(BeanType beanType, Object bean, String property) throws ObjectNotFoundException {
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getProperty(property);
        }
        BeanProperty bp = beanType.tryGetProperty(property);
        if (null != bp) {
            return bp.getValue(bean);
        }
        throw new ObjectNotFoundException("Property '" + property + "' not found in bean class '" + bean.getClass().getName());
    }

    public static Object getNestableProperty(Object bean, String property) {
        if (bean instanceof Map) {
            return Beans.getNestableProperty((Map)bean, property);
        }
        if (bean instanceof DynaBean) {
            return Beans.getNestableProperty(((DynaBean)bean).getProperties(), property);
        }
        return Beans.getNestableProperty(BeanType.of(bean.getClass()), bean, property);
    }

    public static Object getNestableProperty(Map map, String property) {
        if (map.containsKey(property)) {
            return map.get(property);
        }
        int dotIndex = property.indexOf(46);
        if (dotIndex > 0) {
            String namePrefix = property.substring(0, dotIndex);
            Object nestedBean = map.get(namePrefix);
            if (null == nestedBean) {
                return null;
            }
            return Beans.getNestableProperty(nestedBean, property.substring(dotIndex + 1));
        }
        if (property.charAt(property.length() - 1) == ']') {
            int index1 = property.indexOf(91);
            if (index1 > 0) {
                String namePrefix = property.substring(0, index1);
                Object nestedBean = map.get(namePrefix);
                if (null == nestedBean) {
                    return null;
                }
                int arrayIndex = Integer.parseInt(property.substring(index1 + 1, property.length() - 2));
                return Beans.getArrayProperty(nestedBean, arrayIndex);
            }
            throw new IllegalArgumentException("Invalid arrray property name '" + property + ", must be 'property[index]', i.e. 'values[0]'");
        }
        return null;
    }

    public static Object getNestableProperty(BeanType beanType, Object bean, String property) {
        int dotIndex = property.indexOf(46);
        if (dotIndex > 0) {
            String namePrefix = property.substring(0, dotIndex);
            BeanProperty bp = beanType.getProperty(namePrefix);
            return Beans.getNestedProperty(beanType, bean, bp, property.substring(dotIndex + 1));
        }
        if (property.charAt(property.length() - 1) == ']') {
            int index1 = property.indexOf(91);
            if (index1 > 0) {
                String namePrefix = property.substring(0, index1);
                Object nestedBean = beanType.getProperty(namePrefix).getValue(bean);
                if (null == nestedBean) {
                    return null;
                }
                int arrayIndex = Integer.parseInt(property.substring(index1 + 1, property.length() - 2));
                return Beans.getArrayProperty(nestedBean, arrayIndex);
            }
            throw new IllegalArgumentException("Invalid arrray property '" + property + ", must be 'property[index]', i.e. 'values[0]'");
        }
        return beanType.getProperty(property).getValue(bean);
    }

    public static <T> T fromMapNestable(BeanType beanType, Map<String, Object> map) {
        return Beans.setPropertiesNestableInternal(beanType, null, map);
    }

    protected static Object getNestedProperty(BeanType beanType, Object bean, BeanProperty bp, String nestedProperty) {
        Class<?> nestedBeanClass = bp.getType();
        if (Map.class.isAssignableFrom(nestedBeanClass)) {
            return Beans.getNestedMapProperty(beanType, nestedBeanClass, bp, nestedProperty);
        }
        Object nestedBean = bp.getValue(bean);
        if (null == nestedBean) {
            return null;
        }
        return Beans.getNestableProperty(BeanType.of(nestedBeanClass), nestedBean, nestedProperty);
    }

    protected static Object getNestedMapProperty(BeanType beanType, Object bean, BeanProperty bp, String nestedProperty) {
        Map map = (Map)bp.getValue(bean);
        if (null == map) {
            return null;
        }
        if (map.containsKey(nestedProperty)) {
            return map.get(nestedProperty);
        }
        return Beans.getNestableProperty(map, nestedProperty);
    }

    public static void setProperties(BeanType beanType, Object bean, Map<String, Object> map) {
        boolean dyna = bean instanceof DynaBean;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            BeanProperty bp = beanType.tryGetProperty(name);
            if (null != bp) {
                bp.setValue(bean, entry.getValue());
                continue;
            }
            if (!dyna) continue;
            ((DynaBean)bean).setProperty(name, entry.getValue());
        }
    }

    public static void setPropertiesNestable(BeanType beanType, Object bean, Map<String, Object> map) {
        Args.notNull(bean, "bean");
        Beans.setPropertiesNestableInternal(beanType, bean, map);
    }

    private static <T> T setPropertiesNestableInternal(BeanType beanType, T bean, Map<String, Object> map) {
        Map mapBean = null;
        boolean isMap = bean instanceof Map;
        if (isMap) {
            mapBean = (Map)bean;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value;
            String name = entry.getKey();
            BeanProperty bp = beanType.tryGetProperty(name);
            if (null == bp) {
                int dotIndex = name.indexOf(46);
                if (dotIndex > 0) {
                    String namePrefix = name.substring(0, dotIndex);
                    bp = beanType.tryGetProperty(namePrefix);
                    if (null == bp) continue;
                    if (null == bean) {
                        bean = beanType.newInstance();
                    }
                    Beans.setNestedProperty(beanType, bean, bp, name.substring(dotIndex + 1), entry.getValue());
                    continue;
                }
                if (name.charAt(name.length() - 1) == ']') {
                    int index1 = name.indexOf(91);
                    if (index1 > 0) {
                        String namePrefix = name.substring(0, index1);
                        bp = beanType.tryGetProperty(namePrefix);
                        if (null == bp) continue;
                        if (null == bean) {
                            bean = beanType.newInstance();
                        }
                        if (index1 + 1 > name.length() - 1) {
                            Object value2 = entry.getValue();
                            bp.setValue(bean, value2);
                            continue;
                        }
                        String p = name.substring(index1 + 1, name.length() - 1).trim();
                        try {
                            int arrayIndex = Integer.parseInt(p);
                            Beans.setArrayProperty(beanType, bean, bp, arrayIndex, entry.getValue());
                        }
                        catch (NumberFormatException e) {
                            bp.setValue(bean, entry.getValue());
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid arrray property name '" + name + ", must be 'property[index]', i.e. 'values[0]'");
                }
                if (!isMap) continue;
                mapBean.put(name, entry.getValue());
                continue;
            }
            if (null == bean) {
                bean = beanType.newInstance();
            }
            if (null == (value = entry.getValue())) {
                bp.setValue(bean, null);
                continue;
            }
            Class<?> valueType = value.getClass();
            if (valueType.isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Beans.setArrayProperty(beanType, bean, bp, i, Array.get(value, i));
                }
                continue;
            }
            if (Iterable.class.isAssignableFrom(valueType)) {
                int i = 0;
                for (Object item : (Iterable)value) {
                    Beans.setArrayProperty(beanType, bean, bp, i, item);
                    ++i;
                }
                continue;
            }
            bp.setValue(bean, value);
        }
        return bean;
    }

    public static void setProperty(BeanType beanType, Object bean, String property, Object value) {
        Beans.setProperty(beanType, bean, property, value, false);
    }

    public static void setProperty(BeanType beanType, Object bean, String property, Object value, boolean ignoreCase) {
        if (ignoreCase ? beanType.trySetIgnoreCase(bean, property, value) : beanType.trySet(bean, property, value)) {
            return;
        }
        if (bean instanceof DynaBean) {
            ((DynaBean)bean).setProperty(property, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setNestedProperty(BeanType beanType, Object bean, BeanProperty bp, String nestedPropertyName, Object value) {
        Class<?> nestedBeanClass = bp.getType();
        if (Map.class.isAssignableFrom(nestedBeanClass)) {
            Beans.setNestedMapProperty(beanType, bean, bp, nestedPropertyName, value);
            return;
        }
        BeanType nestedBeanType = BeanType.of(nestedBeanClass);
        BeanProperty nestedProperty = nestedBeanType.tryGetProperty(nestedPropertyName);
        if (null == nestedProperty) {
            int dotIndex = nestedPropertyName.indexOf(46);
            if (dotIndex > 0) {
                String namePrefix = nestedPropertyName.substring(0, dotIndex);
                nestedProperty = nestedBeanType.tryGetProperty(namePrefix);
                if (null == nestedProperty) return;
                Object nestedBean = nestedProperty.getValue(bean);
                if (null == nestedBean) {
                    nestedBean = nestedBeanType.newInstance();
                    nestedProperty.setValue(bean, nestedBean);
                }
                Beans.setNestedProperty(nestedBeanType, nestedBean, nestedProperty, nestedPropertyName.substring(dotIndex + 1), value);
                return;
            } else {
                if (nestedPropertyName.charAt(nestedPropertyName.length() - 1) != ']') return;
                int index1 = nestedPropertyName.indexOf(91);
                if (index1 <= 0) throw new IllegalArgumentException("Invalid arrray property name '" + nestedPropertyName + ", must be 'property[index]', i.e. 'values[0]'");
                String namePrefix = nestedPropertyName.substring(0, index1);
                nestedProperty = nestedBeanType.tryGetProperty(namePrefix);
                if (null == nestedProperty) return;
                int arrayIndex = Integer.parseInt(nestedPropertyName.substring(index1 + 1, nestedPropertyName.length() - 2));
                Object nestedBean = nestedProperty.getValue(bean);
                if (null == nestedBean) {
                    nestedBean = nestedBeanType.newInstance();
                    nestedProperty.setValue(bean, nestedBean);
                }
                Beans.setArrayProperty(nestedBeanType, nestedBean, nestedProperty, arrayIndex, value);
            }
            return;
        } else {
            Object nestedBean = nestedProperty.getValue(bean);
            if (null == nestedBean) {
                nestedBean = nestedBeanType.newInstance();
                nestedProperty.setValue(bean, nestedBean);
            }
            nestedProperty.setValue(nestedBean, value);
        }
    }

    protected static void setNestedMapProperty(BeanType beanType, Object bean, BeanProperty bp, String nestedPropertyName, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)bp.getValue(bean);
        if (null == map) {
            Class<?> type = bp.getType();
            if (type.equals(Map.class) || type.equals(HashMap.class)) {
                map = new HashMap<String, Object>();
            } else if (type.equals(LinkedHashMap.class)) {
                map = new LinkedHashMap();
            } else {
                throw new IllegalStateException("Map type '" + type.getName() + "' not supported in class '" + beanType.getBeanClass().getName() + "");
            }
            bp.setValue(bean, map);
        }
        map.put(nestedPropertyName, value);
    }

    protected static Object getArrayProperty(Object object, int index) {
        return Enumerables.of(object).get(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setArrayProperty(BeanType beanType, Object bean, BeanProperty bp, int index, Object value) {
        if (!bp.isWritable()) throw new IllegalStateException(Strings.format("Array property {0} is not writable", bp.getName()));
        Object propertyVal = bp.getValue(bean);
        Class<List> type = bp.getType();
        if (propertyVal == null) {
            if (type.isAssignableFrom(List.class)) {
                ArrayList<?> arr = New.arrayList();
                Beans.tryIncreaseSize(arr, index);
                arr.set(index, Converts.convert(value, bp.getElementType()));
                bp.setValue(bean, arr);
                return;
            } else {
                if (!type.isArray()) throw new IllegalStateException(Strings.format("bean property type '{0}' is not an array or list", bp.getName()));
                if (type.getComponentType().isPrimitive()) {
                    Object arr = Array.newInstance(type.getComponentType(), index + 1);
                    Array.set(arr, index, Converts.convert(value, type.getComponentType()));
                    bp.setValue(bean, arr);
                    return;
                } else {
                    ?[] arr = New.array(type.getComponentType(), index + 1);
                    arr[index] = Converts.convert(value, type.getComponentType());
                    bp.setValue(bean, arr);
                }
            }
            return;
        } else if (type.isAssignableFrom(List.class)) {
            List arr = (List)propertyVal;
            Beans.tryIncreaseSize(arr, index);
            arr.set(index, Converts.convert(value, bp.getElementType()));
            return;
        } else {
            if (!type.isArray()) throw new IllegalStateException(Strings.format("bean property type '{0}' is not an array or list", bp.getName()));
            if (type.getComponentType().isPrimitive()) {
                Object arr = propertyVal;
                int len = Array.getLength(arr);
                if (len <= index) {
                    ArrayList<Object> newArr = New.arrayList();
                    for (int i = 0; i < len; ++i) {
                        newArr.add(Array.get(arr, i));
                    }
                    Beans.tryIncreaseSize(newArr, index);
                    newArr.set(index, Converts.convert(value, type.getComponentType()));
                    bp.setValue(bean, newArr.toArray());
                    return;
                } else {
                    Array.set(arr, index, value);
                }
                return;
            } else {
                Object[] arr = (Object[])propertyVal;
                if (arr.length <= index) {
                    ArrayList<Object> newArr = New.arrayList();
                    for (Object obj : arr) {
                        newArr.add(obj);
                    }
                    Beans.tryIncreaseSize(newArr, index);
                    newArr.set(index, Converts.convert(value, type.getComponentType()));
                    bp.setValue(bean, newArr.toArray());
                    return;
                } else {
                    arr[index] = value;
                }
            }
        }
    }

    protected static void tryIncreaseSize(List list, int maxIndex) {
        if (maxIndex >= list.size()) {
            for (int i = list.size(); i <= maxIndex; ++i) {
                list.add(null);
            }
        }
    }

    protected Beans() {
    }
}

