/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Buildable;
import leap.lang.New;

public class Builders {
    public static <T> T[] buildArray(Collection<? extends Buildable<T>> builders, T[] array) {
        Args.notNull(array);
        if (builders.size() != array.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), builders.size());
        }
        int i = 0;
        for (Buildable<T> builder : builders) {
            array[i++] = builder.build();
        }
        return array;
    }

    public static <T> T[] buildArray(Buildable<T>[] builders, T[] array) {
        Args.notNull(array);
        if (builders.length != array.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), builders.length);
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = builders[i].build();
        }
        return array;
    }

    public static <T> List<T> buildList(Iterable<? extends Buildable<T>> builders) {
        ArrayList<T> list = New.arrayList();
        if (null != builders) {
            for (Buildable<T> b : builders) {
                list.add(b.build());
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> buildMap(Map<K, ? extends Buildable<V>> builders) {
        LinkedHashMap<K, V> m = New.linkedHashMap();
        for (Map.Entry<K, Buildable<V>> e : builders.entrySet()) {
            m.put(e.getKey(), e.getValue().build());
        }
        return m;
    }

    protected Builders() {
    }
}

