/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Charsets;
import leap.lang.Primitives;
import leap.lang.Strings;
import leap.lang.exception.NestedClassNotFoundException;
import leap.lang.io.IO;

public class Classes {
    private static final Map<String, String> abbreviationMap = new HashMap<String, String>();
    private static final Map<String, String> reverseAbbreviationMap = new HashMap<String, String>();
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY;
    public static final String CLASS_FILE_SUFFIX = ".class";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = ".";
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';

    public static Class<?> firstNonVoid(Class<?> ... cs) {
        if (null == cs) {
            return null;
        }
        for (Class<?> c : cs) {
            if (Void.TYPE.equals(c) || Void.class.equals(c)) continue;
            return c;
        }
        return null;
    }

    public static boolean isPresent(String className) {
        return Classes.tryForName(className) != null;
    }

    public static boolean isPresent(ClassLoader classLoader, String className) {
        return Classes.tryForName(classLoader, className) != null;
    }

    public static Class<?> forName(String className) throws NestedClassNotFoundException {
        return Classes.forName(Classes.getClassLoader(), className, true);
    }

    public static Class<?> tryForName(String className) {
        try {
            return Classes.forName(Classes.getClassLoader(), className, true);
        }
        catch (NestedClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> forName(ClassLoader classLoader, String className) throws NestedClassNotFoundException {
        return Classes.forName(classLoader, className, true);
    }

    public static Class<?> tryForName(ClassLoader classLoader, String className) {
        try {
            return Classes.forName(classLoader, className, true);
        }
        catch (NestedClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> tryForName(Class<?> loaderClass, String className) {
        return Classes.tryForName(Classes.getClassLoader(loaderClass), className);
    }

    public static Class<?> forName(Class<?> loaderClass, String className) throws NestedClassNotFoundException {
        return Classes.forName(Classes.getClassLoader(loaderClass), className);
    }

    public static Object getDefaultValue(Class<?> type) {
        if (Integer.TYPE == type) {
            return 0;
        }
        if (Boolean.TYPE == type) {
            return false;
        }
        if (Long.TYPE == type) {
            return 0L;
        }
        if (Float.TYPE == type) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE == type) {
            return 0.0;
        }
        if (Short.TYPE == type) {
            return 0;
        }
        if (Byte.TYPE == type) {
            return 0;
        }
        if (Character.TYPE == type) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = Classes.class.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        return cl;
    }

    public static String getResourceAsString(Class<?> loaderClass, String resource) {
        return Classes.getResourceAsString(loaderClass, resource, Charsets.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> loaderClass, String resource, Charset charset) {
        InputStream is = null;
        try {
            is = loaderClass.getResourceAsStream(resource);
            if (null == is) {
                String string = null;
                return string;
            }
            String string = IO.readString(is, charset);
            return string;
        }
        finally {
            IO.close(is);
        }
    }

    public static String getPackageName(Class<?> clazz) {
        Args.notNull(clazz, "Class must not be null");
        return Classes.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Args.notNull(fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(PACKAGE_SEPARATOR);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static String getPackageResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String getClassResourcePath(Class<?> clazz) {
        return clazz.getName().replace('.', '/') + CLASS_FILE_SUFFIX;
    }

    public static String getClassFileName(Class<?> clazz) {
        Args.notNull(clazz, "Class");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(PACKAGE_SEPARATOR);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getShortName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return Classes.getShortName(cls.getName());
    }

    public static String getShortName(String className) {
        int lastDotIdx;
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(className)) {
            className = reverseAbbreviationMap.get(className);
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return out + arrayPrefix;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationType) {
        return Classes.getAnnotation(annotations, annotationType, false);
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationType, boolean meta) {
        if (null == annotations || annotations.length == 0 || null == annotationType) {
            return null;
        }
        for (int i = 0; i < annotations.length; ++i) {
            T metaAnnotation;
            Annotation a = annotations[i];
            if (a.annotationType().equals(annotationType)) {
                return (T)a;
            }
            if (!meta || null == (metaAnnotation = a.annotationType().getAnnotation(annotationType))) continue;
            return metaAnnotation;
        }
        return null;
    }

    public static Annotation getAnnotationByMetaType(Annotation[] annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation a : annotations) {
            if (!a.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            return a;
        }
        return null;
    }

    public static boolean isAnnotatioinPresent(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        return null != Classes.getAnnotation(annotations, annotationType);
    }

    public static boolean isAnnotatioinPresent(Annotation[] annotations, Class<? extends Annotation> annotationType, boolean meta) {
        return null != Classes.getAnnotation(annotations, annotationType, meta);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = Primitives.wrap(cls)) == null) {
            return false;
        }
        if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = Primitives.unwrap(cls)) == null) {
            return false;
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz != null && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcreteClass(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return !Modifier.isInterface(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || Primitives.isWrapperType(clazz);
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return Classes.isPrimitiveOrWrapper(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(Calendar.class) || clazz.equals(Charset.class) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isVoid(Class<?> clazz) {
        return null != clazz && (Void.TYPE.equals(clazz) || Void.class.equals(clazz));
    }

    public static boolean isString(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(String.class);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    public static boolean isDouble(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Double.TYPE) || clazz.equals(Double.class);
    }

    public static boolean isInteger(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Integer.TYPE) || clazz.equals(Integer.class);
    }

    public static boolean isLong(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Long.TYPE) || clazz.equals(Long.class);
    }

    public static boolean isShort(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Short.TYPE) || clazz.equals(Short.class);
    }

    public static boolean isFloat(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Float.TYPE) || clazz.equals(Float.class);
    }

    public static boolean isBigDecimal(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(BigDecimal.class);
    }

    public static boolean isBigInteger(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(BigInteger.class);
    }

    public static boolean isCharacter(Class<?> clazz) {
        return null == clazz ? false : clazz.equals(Character.TYPE) || clazz.equals(Character.class);
    }

    private static Class<?> forName(ClassLoader classLoader, String className, boolean initialize) throws NestedClassNotFoundException {
        try {
            Class<?> clazz;
            if (abbreviationMap.containsKey(className)) {
                String clsName = "[" + abbreviationMap.get(className);
                clazz = Class.forName(clsName, initialize, classLoader).getComponentType();
            } else {
                clazz = Class.forName(Classes.toCanonicalName(className), initialize, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return Classes.forName(classLoader, className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1), initialize);
                }
                catch (NestedClassNotFoundException nestedClassNotFoundException) {
                    // empty catch block
                }
            }
            throw new NestedClassNotFoundException("Class not found : " + ex.getMessage(), ex);
        }
    }

    private static String toCanonicalName(String className) {
        if ((className = Strings.trim(className)).endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put(primitive, abbreviation);
        reverseAbbreviationMap.put(abbreviation, primitive);
    }

    protected Classes() {
    }

    static {
        Classes.addAbbreviation("int", "I");
        Classes.addAbbreviation("boolean", "Z");
        Classes.addAbbreviation("float", "F");
        Classes.addAbbreviation("long", "J");
        Classes.addAbbreviation("short", "S");
        Classes.addAbbreviation("byte", "B");
        Classes.addAbbreviation("double", "D");
        Classes.addAbbreviation("char", "C");
        EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    }
}

