/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.Collection;
import java.util.function.Predicate;
import leap.lang.Arrays2;

public class Collections2 {
    public static boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return null != c && !c.isEmpty();
    }

    public static boolean contains(Collection<?> collection, Object object) {
        if (null == collection) {
            return false;
        }
        try {
            return collection.contains(object);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static <E> void addAll(Collection<? super E> collection, E[] elements) {
        if (null == collection || null == elements) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            collection.add(elements[i]);
        }
    }

    public static <E> void addAll(Collection<? super E> collection, Iterable<E> elements) {
        if (null == collection || null == elements) {
            return;
        }
        for (E element : elements) {
            collection.add(element);
        }
    }

    public static <E> boolean addIfNotNull(Collection<? super E> collection, E element) {
        if (null == collection || null == element) {
            return false;
        }
        collection.add(element);
        return true;
    }

    public static boolean addIfNotEmpty(Collection<String> stringCollection, String stringElement, boolean trim) {
        if (null == stringCollection || null == stringElement) {
            return false;
        }
        if (trim) {
            stringElement = stringElement.trim();
        }
        if ("".equals(stringElement)) {
            return false;
        }
        stringCollection.add(stringElement);
        return true;
    }

    public static String[] toStringArray(Collection<String> c) {
        if (null == c || c.isEmpty()) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        return c.toArray(new String[c.size()]);
    }

    public static <T> T remove(Collection<T> c, Predicate<T> predicate) {
        Object found = null;
        for (Object object : c) {
            if (!predicate.test(object)) continue;
            found = object;
            break;
        }
        if (null != found) {
            c.remove(found);
        }
        return (T)found;
    }

    protected Collections2() {
    }
}

