/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

public class Confirm {
    private static final ThreadLocal<Boolean> confirm = new ThreadLocal();

    public static void execute(Runnable runnable) {
        try {
            confirm.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            confirm.remove();
        }
    }

    public static boolean isConfirmed() {
        Boolean value = confirm.get();
        return null != value;
    }

    public static void checkConfirmed(String action) throws ConfirmException {
        if (!Confirm.isConfirmed()) {
            throw new ConfirmException("Action '" + action + "' must be confirmed, please use method '" + Confirm.class.getName() + ".execute(Action)' to execute it.");
        }
    }

    public static void checkConfirmed(String action, String reason) throws ConfirmException {
        if (!Confirm.isConfirmed()) {
            throw new ConfirmException("Action '" + action + "' must be confirmed for the reason '" + reason + "', please use method '" + Confirm.class.getName() + ".execute(Action)' to execute it.");
        }
    }

    protected Confirm() {
    }

    public static class ConfirmException
    extends RuntimeException {
        private static final long serialVersionUID = -1820589737343972497L;

        public ConfirmException(String message) {
            super(message);
        }
    }
}

