/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import leap.lang.Dates;
import leap.lang.time.DateFormats;

public class DateTimes {
    public static LocalDate tryParseLocalDate(CharSequence text) {
        Date ld;
        if (null == text || text.length() == 0) {
            return null;
        }
        LocalDate d = DateTimes.tryParseLocalDate(text, DateTimeFormatter.ISO_LOCAL_DATE);
        if (d == null && (d = DateTimes.tryParseLocalDate(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME)) == null && null != (ld = Dates.tryParse(text.toString(), DateFormats.DATETIME_FORMAT))) {
            return DateTimes.toLocalDate(ld);
        }
        return d;
    }

    public static LocalDate tryParseLocalDate(CharSequence text, DateTimeFormatter formatter) {
        try {
            return LocalDate.parse(text, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static LocalTime tryParseLocalTime(CharSequence text) {
        Date d;
        if (null == text || text.length() == 0) {
            return null;
        }
        LocalTime t = DateTimes.tryParseLocalTime(text, DateTimeFormatter.ISO_LOCAL_TIME);
        if (null == t && null == (t = DateTimes.tryParseLocalTime(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME)) && null != (d = Dates.tryParse(text.toString(), DateFormats.DATETIME_FORMAT))) {
            return DateTimes.toLocalTime(d);
        }
        return t;
    }

    public static LocalTime tryParseLocalTime(CharSequence text, DateTimeFormatter formatter) {
        try {
            return LocalTime.parse(text, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static LocalDateTime tryParseLocalDateTime(CharSequence text) {
        if (null == text || text.length() == 0) {
            return null;
        }
        LocalDateTime dt = DateTimes.tryParseLocalDateTime(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        if (dt == null) {
            String s = text.toString();
            Date d = Dates.tryParse(s, DateFormats.DATETIME_FORMAT);
            if (null != d) {
                return DateTimes.toLocalDateTime(d);
            }
            d = Dates.tryParse(s, DateFormats.DATE_FORMAT);
            if (null != d) {
                return DateTimes.toLocalDateTime(d);
            }
        }
        return dt;
    }

    public static LocalDateTime tryParseLocalDateTime(CharSequence text, DateTimeFormatter formatter) {
        try {
            return LocalDateTime.parse(text, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static Instant tryParseInstant(CharSequence text) {
        if (null == text || text.length() == 0) {
            return null;
        }
        try {
            return Instant.parse(text);
        }
        catch (DateTimeParseException e) {
            Date d = Dates.tryParse(text.toString());
            if (null != d) {
                return d.toInstant();
            }
            return null;
        }
    }

    public static LocalDate toLocalDate(Date d) {
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate toLocalDate(Instant i) {
        return LocalDateTime.ofInstant(i, ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date d) {
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalTime toLocalTime(Instant i) {
        return LocalDateTime.ofInstant(i, ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(Date d) {
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Instant i) {
        return LocalDateTime.ofInstant(i, ZoneId.systemDefault());
    }

    protected DateTimes() {
    }
}

