/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import leap.lang.time.DateFormats;

public class Dates {
    public static final long MILLIS_ONE_SECOND = 1000L;
    public static final long MILLIS_ONE_MINUTE = 60000L;
    public static final long MILLIS_ONE_HOUR = 3600000L;
    public static final long MILLIS_ONE_DAY = 86400000L;
    public static final long MILLIS_ONE_YEAR = 31536000000L;

    protected Dates() {
    }

    public static String format(Date date) {
        return DateFormats.getFormat(date.getClass()).format(date);
    }

    public static String format(Date date, String pattern) {
        return DateFormats.getFormat(pattern).format(date);
    }

    public static Date parse(String string) throws IllegalArgumentException {
        return Dates.parse(string, DateFormats.DEFAULT_PATTERNS, true, false);
    }

    public static Date tryParse(String string) {
        return Dates.parse(string, DateFormats.DEFAULT_PATTERNS, true, true);
    }

    public static Date parse(String string, String ... patterns) throws IllegalArgumentException {
        return Dates.parse(string, patterns, true, false);
    }

    public static Date tryParse(String string, String ... patterns) {
        return Dates.parse(string, patterns, true, true);
    }

    public static Date tryParse(String string, DateFormat format) {
        return Dates.parse(string, format, true, true);
    }

    public static Calendar toCalendar(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public static Date zero(Date date, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(field, 0);
        return c.getTime();
    }

    private static Date parse(String string, String[] patterns, boolean lenient, boolean returnNull) throws IllegalArgumentException {
        if (string == null || patterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        DateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        String[] stringArray = patterns;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Date date;
            String parsePattern;
            String pattern = parsePattern = stringArray[i];
            if (parsePattern.endsWith("ZZ")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            parser = DateFormats.getFormat(pattern);
            pos.setIndex(0);
            String str2 = string;
            if (parsePattern.endsWith("ZZ")) {
                str2 = string.replaceAll("([-+][0-9][0-9]):([0-9][0-9])$", "$1$2");
            }
            if (str2.endsWith("Z")) {
                int index = string.lastIndexOf("Z");
                str2 = string.substring(0, index) + "+0000";
            }
            if ((date = parser.parse(str2, pos)) == null || pos.getIndex() != str2.length()) continue;
            return date;
        }
        if (!returnNull) {
            throw new IllegalArgumentException("Unable to parse the date: " + string);
        }
        return null;
    }

    private static Date parse(String string, DateFormat format, boolean lenient, boolean returnNull) throws IllegalArgumentException {
        ParsePosition pos = new ParsePosition(0);
        pos.setIndex(0);
        String str2 = string;
        Date date = format.parse(str2, pos);
        if (date != null && pos.getIndex() == str2.length()) {
            return date;
        }
        if (!returnNull) {
            throw new IllegalArgumentException("Unable to parse the date: " + string);
        }
        return null;
    }
}

