/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.Collection;
import java.util.List;
import leap.lang.Enumerable;
import leap.lang.collection.ArrayIterable;
import leap.lang.collection.ArrayObjectIterable;
import leap.lang.collection.CollectionEnumerable;
import leap.lang.collection.EmptyIterable;
import leap.lang.collection.IterableEnumerable;
import leap.lang.collection.ListEnumerable;

public class Enumerables {
    public static final Enumerable EMPTY = new EmptyIterable();

    public static final <E> Enumerable<E> empty() {
        return EMPTY;
    }

    public static final <E> Enumerable<E> of(Object object) throws IllegalArgumentException {
        Enumerable<E> e = Enumerables.tryOf(object);
        if (null == e) {
            throw new IllegalArgumentException("not a supported enumerable type '" + object.getClass().getName() + "'");
        }
        return e;
    }

    public static final <E> Enumerable<E> tryOf(Object object) throws IllegalArgumentException {
        if (null == object) {
            return Enumerables.empty();
        }
        if (object instanceof Enumerable) {
            return (Enumerable)object;
        }
        if (object instanceof List) {
            return new ListEnumerable((List)object);
        }
        if (object instanceof Collection) {
            return new CollectionEnumerable((Collection)object);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return new ArrayObjectIterable(object);
            }
            return Enumerables.ofArray((Object[])object);
        }
        if (object instanceof Iterable) {
            return new IterableEnumerable((Iterable)object);
        }
        return null;
    }

    public static final <E> Enumerable<E> ofArray(E ... array) {
        return null == array || array.length == 0 ? EMPTY : new ArrayIterable<E>(array);
    }

    protected Enumerables() {
    }
}

