/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import leap.lang.Strings;
import leap.lang.reflect.ReflectEnum;

public class Enums {
    public static Object getValue(Enum<?> enumObject) {
        ReflectEnum reflectEnum = ReflectEnum.of(enumObject.getClass());
        if (reflectEnum.isValued()) {
            return reflectEnum.getValue(enumObject);
        }
        return enumObject.toString();
    }

    public static <E extends Enum<?>> E valueOf(Class<E> enumType, Object value) throws IllegalStateException {
        if (null == value) {
            return null;
        }
        String stringValue = value.toString();
        ReflectEnum reflectEnum = ReflectEnum.of(enumType);
        if (reflectEnum.isValued()) {
            for (Enum e : (Enum[])enumType.getEnumConstants()) {
                if (!reflectEnum.getValue(e).toString().equals(stringValue)) continue;
                return (E)e;
            }
        } else {
            if (stringValue.equals("")) {
                return null;
            }
            for (Enum e : (Enum[])enumType.getEnumConstants()) {
                if (!e.toString().equals(stringValue)) continue;
                return (E)e;
            }
        }
        throw new IllegalStateException("Invalid enum value '" + value + "' of type '" + enumType.getName() + "'");
    }

    public static <E extends Enum<?>> E nameOf(Class<E> enumType, String name) throws IllegalStateException {
        return Enums.nameOf(enumType, name, true);
    }

    public static <E extends Enum<?>> E nameOf(Class<E> enumType, String name, boolean ignorecase) throws IllegalStateException {
        if (Strings.isEmpty(name)) {
            return null;
        }
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            if (!(ignorecase ? e.name().equalsIgnoreCase(name) : e.name().equals(name))) continue;
            return (E)e;
        }
        throw new IllegalStateException("Invalid enum name '" + name + "' of type '" + enumType.getName() + "'");
    }

    public static String[] getValues(Class<?> enumType) {
        ReflectEnum reflectEnum = ReflectEnum.of(enumType);
        String[] values = new String[enumType.getEnumConstants().length];
        for (int i = 0; i < values.length; ++i) {
            String v;
            Object e = enumType.getEnumConstants()[i];
            values[i] = v = reflectEnum.isValued() ? String.valueOf(reflectEnum.getValue(e)) : e.toString();
        }
        return values;
    }

    protected Enums() {
    }
}

