/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.Serializable;
import leap.lang.Args;

public class Error
implements Serializable {
    private static final long serialVersionUID = -3060382631017010667L;
    public static final Error EMPTY = new Error("err");
    protected final String code;
    protected final String message;
    protected final Throwable cause;

    public Error(String message) {
        this(null, message, null);
    }

    public Error(String code, String message) {
        this(code, message, null);
    }

    public Error(String code, String message, Throwable cause) {
        Args.notEmpty(message, "error message");
        this.code = code;
        this.message = message;
        this.cause = cause;
    }

    public Error(Throwable cause) {
        Args.notNull(cause);
        this.code = null;
        this.cause = cause;
        this.message = cause.getMessage();
    }

    public Error(String message, Throwable cause) {
        Args.notEmpty(message, "error message");
        this.code = null;
        this.message = message;
        this.cause = cause;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return "Error[code=" + this.code + ",message=" + this.message + "]";
    }
}

