/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.function.Supplier;
import leap.lang.exception.NestedIOException;
import leap.lang.exception.NestedSQLException;
import leap.lang.exception.NestedUnsupportedEncodingException;
import leap.lang.io.IO;

public class Exceptions {
    public static RuntimeException uncheck(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException uncheck(Throwable e, Supplier<RuntimeException> re) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return re.get();
    }

    public static void uncheckAndThrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static void uncheckAndThrow(Throwable e, Supplier<RuntimeException> re) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw re.get();
    }

    public static NestedSQLException wrap(SQLException e) {
        return new NestedSQLException(e);
    }

    public static void wrapAndThrow(SQLException e) {
        throw new NestedSQLException(e);
    }

    public static NestedSQLException wrap(String message, SQLException e) {
        return new NestedSQLException(message, e);
    }

    public static void wrapAndThrow(String message, SQLException e) {
        throw new NestedSQLException(message, e);
    }

    public static NestedIOException wrap(IOException e) {
        return new NestedIOException(e);
    }

    public static void wrapAndThrow(IOException e) {
        throw new NestedIOException(e);
    }

    public static NestedIOException wrap(String message, IOException e) {
        return new NestedIOException(message, e);
    }

    public static void wrapAndThrow(String message, IOException e) {
        throw new NestedIOException(message, e);
    }

    public static NestedUnsupportedEncodingException wrap(UnsupportedEncodingException e) {
        return new NestedUnsupportedEncodingException(e);
    }

    public static NestedUnsupportedEncodingException wrap(String message, UnsupportedEncodingException e) {
        return new NestedUnsupportedEncodingException(message, e);
    }

    public static void wrapAndThrow(String message, UnsupportedEncodingException e) {
        throw new NestedUnsupportedEncodingException(message, e);
    }

    public static UnsupportedOperationException notImplemented() {
        return new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
        finally {
            IO.close(pw);
            IO.close(sw);
        }
    }

    protected Exceptions() {
    }
}

