/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Extensible;

public abstract class ExtensibleBase
implements Extensible {
    protected final Map<Class<?>, Object> extensions = new ConcurrentHashMap();

    protected ExtensibleBase() {
    }

    protected ExtensibleBase(Map<Class<?>, Object> extensions) {
        this.putExtensions(extensions);
    }

    @Override
    public final <T> T getExtension(Class<?> type) {
        return (T)this.extensions.get(type);
    }

    @Override
    public final <T> void setExtension(Class<T> type, Object extension) {
        this.extensions.put(type, extension);
    }

    @Override
    public <T> T removeExtension(Class<?> type) {
        return (T)this.extensions.remove(type);
    }

    protected final void putExtensions(Map<Class<?>, Object> extensions) {
        if (null != extensions) {
            this.extensions.putAll(extensions);
        }
    }
}

