/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.FactoryException;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.exception.NestedIOException;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.io.IO;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceSet;
import leap.lang.resource.Resources;
import leap.lang.resource.SimpleResourceSet;

public class Factory {
    private static final String META_PREFIX = "META-INF/services/";
    private static final String APP_PREIFIX = "/services/";
    private static final String CLASS_PROPERTY = "class";
    private static Map<Class<?>, Object> singleInstances = new ConcurrentHashMap(10);

    public static <T> T getInstance(Class<T> type) {
        Object object = singleInstances.get(type);
        if (null == object) {
            object = Factory.newInstance(type);
            singleInstances.put(type, object);
        }
        return (T)object;
    }

    public static <T> T newInstance(Class<T> type) throws ObjectNotFoundException, FactoryException {
        Args.notNull(type);
        Resource resource = Factory.getSingleClassNameResource(type);
        if (null == resource) {
            throw new ObjectNotFoundException("no instance of service class '" + type.getName() + "'");
        }
        return Factory.newInstance(type, resource);
    }

    public static <T> T newInstance(Class<T> type, Class<? extends T> defaultConcreteClass) {
        Args.notNull(type);
        Args.notNull(defaultConcreteClass);
        Resource resource = Factory.getSingleClassNameResource(type);
        if (null == resource || !resource.exists()) {
            try {
                return defaultConcreteClass.newInstance();
            }
            catch (Exception e) {
                throw new FactoryException("Error new instance of class '" + defaultConcreteClass.getName() + "'", e);
            }
        }
        return Factory.newInstance(type, resource);
    }

    public static <T> List<T> newInstances(Class<T> type) {
        Args.notNull(type);
        ResourceSet resources = Factory.getAllClassNameResources(type);
        ArrayList<T> instances = new ArrayList<T>();
        for (Resource resource : resources) {
            instances.add(Factory.newInstance(type, resource));
        }
        return instances;
    }

    public static <T> Map<String, T> newNamedInstances(Class<T> type) {
        Args.notNull(type);
        ResourceSet resources = Factory.getAllNamedClassNameResources(type);
        LinkedHashMap<String, T> instances = new LinkedHashMap<String, T>();
        for (Resource resource : resources) {
            instances.put(resource.getFilename(), Factory.newInstance(type, resource));
        }
        return instances;
    }

    private static Resource getSingleClassNameResource(Class<?> type) {
        Resource r = Resources.getResource("classpath:/services/" + type.getName());
        if (r.exists()) {
            return r;
        }
        return Resources.getResource("classpath:META-INF/services/" + type.getName());
    }

    private static ResourceSet getAllClassNameResources(Class<?> type) {
        ResourceSet rs1 = Resources.scan("classpath*:META-INF/services/" + type.getName().replace('.', '/') + "/?*");
        ResourceSet rs2 = Resources.scan("classpath*:META-INF/services/" + type.getName());
        return new SimpleResourceSet(Arrays2.concat(rs1.toResourceArray(), rs2.toResourceArray()));
    }

    private static ResourceSet getAllNamedClassNameResources(Class<?> type) {
        return Resources.scan("classpath*:META-INF/services/" + type.getName().replace('.', '/') + "/?*");
    }

    private static <T> T newInstance(Class<T> type, Resource resource) {
        Properties properties = Factory.readProperties(resource);
        String className = properties.getProperty(CLASS_PROPERTY);
        if (Strings.isEmpty(className)) {
            throw new FactoryException("the 'class' property must not be empty in classpath resource : " + resource.getClasspath());
        }
        Class<?> clazz = Classes.tryForName(className);
        if (null == clazz) {
            throw new FactoryException("class '" + className + "' not found, check the 'class' property in classpath resource : " + resource.getClasspath());
        }
        T object = null;
        try {
            object = (T)clazz.newInstance();
            BeanType beanType = BeanType.of(clazz);
            for (Object key : properties.keySet()) {
                String name = (String)key;
                if (Strings.equals(CLASS_PROPERTY, name)) continue;
                BeanProperty bp = beanType.getProperty(name);
                String value = properties.getProperty(name);
                bp.setValue(object, value);
            }
        }
        catch (Exception e) {
            throw new FactoryException("Error creating instance of class '" + className + "', classpath resource : " + resource.getClasspath(), e);
        }
        return object;
    }

    private static Properties readProperties(Resource resource) {
        InputStream is = null;
        try {
            is = resource.getInputStream();
            Properties properties = new Properties();
            if (Strings.endsWithIgnoreCase(resource.getFilename(), ".xml")) {
                properties.loadFromXML(is);
            } else {
                properties.load(is);
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
        finally {
            IO.close(is);
        }
    }

    protected Factory() {
    }
}

