/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import leap.lang.Args;
import leap.lang.Collections2;
import leap.lang.Iterators;
import leap.lang.New;
import leap.lang.annotation.Nullable;

public class Iterables {
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        if (null == iterable) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> parallelStream(Iterable<T> iterable) {
        if (null == iterable) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), true);
    }

    public static <T> T get(Iterable<T> iterable, int position) {
        Args.notNull(iterable);
        return (T)(iterable instanceof List ? ((List)iterable).get(position) : Iterators.get(iterable.iterator(), position));
    }

    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Iterators.size(iterable.iterator());
    }

    public static boolean contains(Iterable<?> iterable, @Nullable Object element) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return Collections2.contains(collection, element);
        }
        return Iterators.contains(iterable.iterator(), element);
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.any(iterable.iterator(), predicate);
    }

    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.all(iterable.iterator(), predicate);
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return Iterators.firstOrNull(iterable.iterator());
    }

    public static <T> T firstOrNull(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.firstOrNull(iterable.iterator(), predicate);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return iterable instanceof List ? (ArrayList<T>)iterable : New.arrayList(iterable);
    }

    public static Object[] toArray(Iterable<?> iterable) {
        return Iterables.toCollection(iterable).toArray();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        Collection<T> collection = Iterables.toCollection(iterable);
        T[] array = New.array(type, collection.size());
        return collection.toArray(array);
    }

    static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : New.arrayList(iterable.iterator());
    }

    protected Iterables() {
    }
}

