/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.Iterator;
import java.util.function.Predicate;
import leap.lang.Args;
import leap.lang.Predicates;
import leap.lang.annotation.Nullable;

public class Iterators {
    public static <T> T get(Iterator<T> iterator, int position) {
        Iterators.checkNonnegative(position);
        int skipped = Iterators.advance(iterator, position);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("position (" + position + ") must be less than the number of elements that remained (" + skipped + ")");
        }
        return iterator.next();
    }

    public static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object element) {
        return Iterators.any(iterator, Predicates.equalTo(element));
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterator, predicate) != -1;
    }

    public static <T> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Args.notNull(predicate);
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> T firstOrNull(Iterator<T> iterator) {
        Args.notNull(iterator);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T firstOrNull(Iterator<T> iterator, Predicate<? super T> predicate) {
        Args.notNull(iterator);
        Args.notNull(predicate);
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Args.notNull(predicate, "predicate");
        int i = 0;
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (predicate.test(current)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int advance(Iterator<?> iterator, int numberToAdvance) {
        int i;
        Args.notNull(iterator);
        Args.assertTrue(numberToAdvance >= 0, "numberToAdvance");
        for (i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    static void checkNonnegative(int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException("position (" + position + ") must not be negative");
        }
    }

    protected Iterators() {
    }
}

