/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

public class Java {
    public static final String JAVA_SPECIFICATION_VERSION = System.getProperty("java.specification.version");
    private static final Version JAVA_SPECIFICATION_VERSION_ENUM = Version.get(JAVA_SPECIFICATION_VERSION);

    public static Version version() {
        return JAVA_SPECIFICATION_VERSION_ENUM;
    }

    public static boolean isVersionAtLeast(Version requiredVersion) {
        return Java.version().atLeast(requiredVersion);
    }

    protected Java() {
    }

    public static enum Version {
        JAVA_0_9(1.5f, "0.9"),
        JAVA_1_1(1.1f, "1.1"),
        JAVA_1_2(1.2f, "1.2"),
        JAVA_1_3(1.3f, "1.3"),
        JAVA_1_4(1.4f, "1.4"),
        JAVA_1_5(1.5f, "1.5"),
        JAVA_1_6(1.6f, "1.6"),
        JAVA_1_7(1.7f, "1.7"),
        JAVA_1_8(1.8f, "1.8");

        private float value;
        private String name;

        private Version(float value, String name) {
            this.value = value;
            this.name = name;
        }

        public boolean atLeast(Version requiredVersion) {
            return this.value >= requiredVersion.value;
        }

        static Version getJavaVersion(String nom) {
            return Version.get(nom);
        }

        static Version get(String nom) {
            if ("0.9".equals(nom)) {
                return JAVA_0_9;
            }
            if ("1.1".equals(nom)) {
                return JAVA_1_1;
            }
            if ("1.2".equals(nom)) {
                return JAVA_1_2;
            }
            if ("1.3".equals(nom)) {
                return JAVA_1_3;
            }
            if ("1.4".equals(nom)) {
                return JAVA_1_4;
            }
            if ("1.5".equals(nom)) {
                return JAVA_1_5;
            }
            if ("1.6".equals(nom)) {
                return JAVA_1_6;
            }
            if ("1.7".equals(nom)) {
                return JAVA_1_7;
            }
            if ("1.8".equals(nom)) {
                return JAVA_1_8;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

