/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.ArrayList;
import java.util.Locale;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.path.Paths;

public class Locales {
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();

    public static Locale forName(String localeName) {
        Args.notEmpty(localeName, "locale name");
        int len = localeName.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + localeName);
        }
        char ch0 = localeName.charAt(0);
        char ch1 = localeName.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + localeName);
        }
        if (len == 2) {
            return new Locale(localeName, "");
        }
        if (localeName.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + localeName);
        }
        char ch3 = localeName.charAt(3);
        if (ch3 == '_') {
            return new Locale(localeName.substring(0, 2), "", localeName.substring(4));
        }
        char ch4 = localeName.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + localeName);
        }
        if (len == 5) {
            return new Locale(localeName.substring(0, 2), localeName.substring(3, 5));
        }
        if (localeName.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + localeName);
        }
        return new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6));
    }

    public static String extractFromFilename(String filename) {
        String[] parts = Strings.split(filename = Paths.getFileNameWithoutExtension(filename), "_");
        String localeName = parts.length == 2 ? parts[1] : (parts.length >= 3 ? parts[1] + "_" + parts[2] : "");
        if (!Strings.isEmpty(localeName)) {
            try {
                Locales.forName(localeName);
            }
            catch (Exception e) {
                return "";
            }
        }
        return localeName;
    }

    public static String[] getLocalePaths(Locale locale, String path) {
        String country;
        ArrayList<String> paths = new ArrayList<String>();
        String lang = null == locale ? null : locale.getLanguage();
        String string = country = null == locale ? null : locale.getCountry();
        if (!Strings.isEmpty(country)) {
            paths.add(path + "_" + lang + "_" + country);
        }
        if (!Strings.isEmpty(lang)) {
            paths.add(path + "_" + lang);
        }
        paths.add(path);
        return paths.toArray(new String[paths.size()]);
    }

    public static String[] getLocalePaths(Locale locale, String path, String suffix) {
        String country;
        ArrayList<String> paths = new ArrayList<String>();
        if (null == suffix) {
            suffix = "";
        } else if (path.endsWith(suffix)) {
            path = Strings.removeEnd(path, suffix);
        }
        String lang = null == locale ? null : locale.getLanguage();
        String string = country = null == locale ? null : locale.getCountry();
        if (!Strings.isEmpty(country)) {
            paths.add(path + "_" + lang + "_" + country + suffix);
        }
        if (!Strings.isEmpty(lang)) {
            paths.add(path + "_" + lang + suffix);
        }
        paths.add(path + suffix);
        return paths.toArray(new String[paths.size()]);
    }

    public static String[] getLocaleFilePaths(Locale locale, String filePath) {
        String ext = Paths.getFileExtension(filePath);
        String path = Strings.isEmpty(ext) ? filePath : filePath.substring(0, filePath.length() - ext.length() - 1);
        return Locales.getLocalePaths(locale, path, "." + ext);
    }

    protected Locales() {
    }
}

