/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.Map;
import java.util.function.Consumer;
import leap.lang.Objects2;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.text.PlaceholderResolver;

public class Maps {
    public static boolean isEmpty(Map map) {
        return null == map || map.isEmpty();
    }

    public static <K, V> K getFirstKey(Map<K, V> map, V value) {
        if (null == map || null == value) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> T get(Map map, Object key) {
        T v = null == map ? null : (T)map.get(key);
        return null == v ? null : v;
    }

    public static <T> T get(Map map, Object key, Class<T> type) {
        T v = Maps.get(map, key);
        return null == v ? null : (T)Converts.convert(v, type);
    }

    public static <T> T get(Map map, Object key, Class<T> type, T defaultValue) {
        T v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, type);
    }

    public static String getString(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.toString(v);
    }

    public static String getString(Map map, Object key, String defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.toString(v);
    }

    public static String getStringRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        String s = Converts.toString(v);
        if (s.length() == 0) {
            throw new IllegalStateException("The string of key '" + key + "' must not be empty in map");
        }
        return s;
    }

    public static Integer getInteger(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.convert(v, Integer.class);
    }

    public static Integer getInteger(Map map, Object key, Integer defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, Integer.class);
    }

    public static Integer getIntegerRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, Integer.class);
    }

    public static Long getLong(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.convert(v, Long.class);
    }

    public static Long getLong(Map map, Object key, Long defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, Long.class);
    }

    public static Long getLongRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, Long.class);
    }

    public static Boolean getBoolean(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.convert(v, Boolean.class);
    }

    public static Boolean getBoolean(Map map, Object key, Boolean defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, Boolean.class);
    }

    public static Boolean getBooleanRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, Boolean.class);
    }

    public static Float getFloat(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.convert(v, Float.class);
    }

    public static Float getFloat(Map map, Object key, Float defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, Float.class);
    }

    public static Float getFloatRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, Float.class);
    }

    public static Double getDouble(Map map, Object key) {
        Object v = Maps.get(map, key);
        return null == v ? null : Converts.convert(v, Double.class);
    }

    public static Double getDouble(Map map, Object key, Double defaultValue) {
        Object v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, Double.class);
    }

    public static Double getDoubleRequired(Map map, Object key) {
        Object v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, Double.class);
    }

    public static <T> T getValue(Map map, Object key, Class<T> targetType) {
        T v = Maps.get(map, key);
        return null == v ? null : (T)Converts.convert(v, targetType);
    }

    public static <T> T getValue(Map map, Object key, Class<T> targetType, T defaultValue) {
        T v = Maps.get(map, key);
        return null == v ? defaultValue : Converts.convert(v, targetType);
    }

    public static <T> T getValueRequired(Map map, Object key, Class<T> targetType) {
        if (String.class == targetType) {
            return (T)Maps.getStringRequired(map, key);
        }
        T v = Maps.get(map, key);
        if (null == v) {
            throw new IllegalStateException("The key '" + key + "' must be exists in map");
        }
        return Converts.convert(v, targetType);
    }

    public static <T> boolean accept(Map map, Object key, Class<T> type, Consumer<T> consumer) {
        Object r;
        T v = Maps.get(map, key);
        Object t = r = null == v ? null : (Object)Converts.convert(v, type);
        if (!Objects2.isEmpty(r)) {
            consumer.accept(r);
            return true;
        }
        return false;
    }

    public static void resolveValues(Map<String, String> map, PlaceholderResolver pr) {
        if (null != map && null != pr) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String resolved;
                String name = entry.getKey();
                String value = entry.getValue();
                if (Strings.isEmpty(value) || value.equals(resolved = pr.resolveString(value))) continue;
                map.put(name, resolved);
            }
        }
    }

    protected Maps() {
    }
}

