/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import leap.lang.Strings;

public class Patterns {
    private static final Map<String, Integer> flags = new HashMap<String, Integer>();
    private static String ATOM;
    private static String DOMAIN;
    private static String IP_DOMAIN;
    public static final String EMAIL_REGEX;
    public static final Pattern EMAIL_PATTERN;

    public static boolean matches(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    public static int parseFlags(String flags) {
        String[] flagNames = Strings.split(flags, "|");
        int flag = 0;
        for (String name : flagNames) {
            Integer value = Patterns.flags.get(name);
            if (null == value) {
                throw new IllegalStateException("Invalid pattern flag '" + name + "'");
            }
            flag |= value.intValue();
        }
        return flag;
    }

    protected Patterns() {
    }

    static {
        flags.put("CANON_EQ", 128);
        flags.put("CASE_INSENSITIVE", 2);
        flags.put("COMMENTS", 4);
        flags.put("DOTALL", 32);
        flags.put("LITERAL", 16);
        flags.put("MULTILINE", 8);
        flags.put("UNICODE_CASE", 64);
        flags.put("UNICODE_CHARACTER_CLASS", 256);
        flags.put("UNIX_LINES", 1);
        ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
        DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
        IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
        EMAIL_REGEX = "^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$";
        EMAIL_PATTERN = Pattern.compile(EMAIL_REGEX, 2);
    }
}

