/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Predicate;
import leap.lang.Args;
import leap.lang.Named;
import leap.lang.Strings;
import leap.lang.annotation.Nullable;

public class Predicates {
    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    public static <T extends Named> Predicate<T> nameEquals(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean test(T object) {
                return Strings.equals(object.getName(), name);
            }
        };
    }

    public static <T extends Named> Predicate<T> nameEqualsIgnoreCase(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean test(T object) {
                return Strings.equalsIgnoreCase(object.getName(), name);
            }
        };
    }

    public static <K, V> Predicate<Map.Entry<K, V>> entryKeyEquals(final K key) {
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return entry.getKey().equals(key);
            }
        };
    }

    public static <V> Predicate<Map.Entry<String, V>> entryKeyEqualsIgnoreCase(final String key) {
        return new Predicate<Map.Entry<String, V>>(){

            @Override
            public boolean test(Map.Entry<String, V> entry) {
                return entry.getKey().equalsIgnoreCase(key);
            }
        };
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    public static Predicate<Class<?>> annotatedWith(final Class<? extends Annotation> ... annotationClasses) {
        return new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> input) {
                for (int i = 0; i < annotationClasses.length; ++i) {
                    if (!input.isAnnotationPresent(annotationClasses[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    protected Predicates() {
    }

    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;
        private static final long serialVersionUID = 0L;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public boolean test(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    private static class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        private InstanceOfPredicate(Class<?> clazz) {
            this.clazz = Args.notNull(clazz);
        }

        @Override
        public boolean test(@Nullable Object o) {
            return this.clazz.isInstance(o);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == that.clazz;
            }
            return false;
        }

        public String toString() {
            return "IsInstanceOf(" + this.clazz.getName() + ")";
        }
    }

    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            @Override
            public boolean test(@Nullable Object o) {
                return true;
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public boolean test(@Nullable Object o) {
                return false;
            }
        }
        ,
        IS_NULL{

            @Override
            public boolean test(@Nullable Object o) {
                return o == null;
            }
        }
        ,
        NOT_NULL{

            @Override
            public boolean test(@Nullable Object o) {
                return o != null;
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }
}

