/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.Try;
import leap.lang.accessor.PropertyGetter;
import leap.lang.convert.Converts;
import leap.lang.exception.NestedIOException;
import leap.lang.extension.ExProperties;
import leap.lang.io.IO;
import leap.lang.resource.Resource;

public class Props {
    public static ExProperties load(Resource r) throws NestedIOException {
        try {
            if (r.isFile()) {
                return Props.load(r.getFile());
            }
            ExProperties p = new ExProperties();
            if (Strings.endsWithIgnoreCase(r.getFilename(), ".xml")) {
                try (InputStream in = r.getInputStream();){
                    p.loadFromXML(in);
                }
            }
            try (InputStreamReader reader = r.getInputStreamReader();){
                p.load(reader);
            }
            return p;
        }
        catch (IOException e) {
            throw new NestedIOException("Error loading properties from resource '" + r.getDescription() + "', " + e.getMessage(), e);
        }
    }

    public static ExProperties loadKeyValues(String content) {
        ExProperties props = new ExProperties();
        if (null != content) {
            Try.throwUnchecked(() -> {
                try (StringReader reader = new StringReader(content);){
                    props.load(reader);
                }
            });
        }
        return props;
    }

    public static ExProperties load(File file) throws NestedIOException {
        return Props.load(file, null);
    }

    public static ExProperties load(File file, Properties defaults) throws NestedIOException {
        Args.notNull(file, "file");
        try {
            ExProperties props;
            ExProperties exProperties = props = null == defaults ? new ExProperties(file) : new ExProperties(file, defaults);
            if (Strings.endsWithIgnoreCase(file.getName(), ".xml")) {
                try (FileInputStream in = new FileInputStream(file);){
                    props.loadFromXML(in);
                }
            }
            try (Reader reader = IO.createReader(file, Charset.defaultCharset());){
                props.load(reader);
            }
            return props;
        }
        catch (IOException e) {
            throw new NestedIOException("Error loading properties file '" + file.getAbsolutePath() + "', " + e.getMessage(), e);
        }
    }

    public static void save(Properties props, File file) throws NestedIOException {
        block28: {
            Args.notNull(props, "properties");
            Args.notNull(file, "file");
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (Strings.endsWithIgnoreCase(file.getName(), ".xml")) {
                    try (FileOutputStream out = new FileOutputStream(file);){
                        props.storeToXML(out, "");
                        break block28;
                    }
                }
                try (Writer writer = IO.createWriter(file);){
                    props.store(writer, "");
                }
            }
            catch (IOException e) {
                throw new NestedIOException("Error saving properties file '" + file.getAbsolutePath() + "', " + e.getMessage(), e);
            }
        }
    }

    public static Integer getInteger(Properties properties, String key) {
        return Props.get(properties, key, Integer.class);
    }

    public static int getInteger(Properties properties, String key, int defaultValue) {
        return Props.get(properties, key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static boolean getBoolean(Properties properties, String key) {
        return Props.get(properties, key, Boolean.class);
    }

    public static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        return Props.get(properties, key, Boolean.class, Boolean.valueOf(defaultValue));
    }

    public static <T> T get(PropertyGetter properties, String key, Class<T> targetType) {
        if (null == properties || null == key) {
            return null;
        }
        String value = properties.getProperty(key.toString());
        if (null == value || Strings.isEmpty(value = value.trim())) {
            return null;
        }
        return Converts.convert(value, targetType);
    }

    public static <T> T get(PropertyGetter properties, String key, Class<T> targetType, T defaultValue) {
        if (null == properties || null == key) {
            return defaultValue;
        }
        String value = properties.getProperty(key.toString());
        if (null == value || Strings.isEmpty(value = value.trim())) {
            return defaultValue;
        }
        return Converts.convert(value, targetType);
    }

    public static <T> T get(Properties properties, String key, Class<T> targetType) {
        if (null == properties || null == key) {
            return null;
        }
        String value = properties.getProperty(key);
        if (null == value || Strings.isEmpty(value = value.trim())) {
            return null;
        }
        return Converts.convert(value, targetType);
    }

    public static <T> T get(Properties properties, String key, Class<T> targetType, T defaultValue) {
        if (null == properties || null == key) {
            return defaultValue;
        }
        String value = properties.getProperty(key);
        if (null == value || Strings.isEmpty(value = Strings.trim(value))) {
            return defaultValue;
        }
        return Converts.convert(value, targetType);
    }

    public static <T> T remove(Properties properties, String key, Class<T> targetType) {
        if (null == properties || null == key) {
            return null;
        }
        Object value = properties.remove(key);
        if (null == value || value instanceof String && Strings.isEmpty((String)(value = ((String)value).trim()))) {
            return null;
        }
        return Converts.convert(value, targetType);
    }

    public static <T> T remove(Properties properties, String key, Class<T> targetType, T defaultValue) {
        if (null == properties || null == key) {
            return defaultValue;
        }
        Object value = properties.remove(key);
        if (null == value || value instanceof String && Strings.isEmpty((String)(value = ((String)value).trim()))) {
            return defaultValue;
        }
        return Converts.convert(value, targetType);
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.getProperty(key);
                if (value == null) {
                    value = props.get(key);
                }
                map.put(key, value);
            }
        }
    }

    public static Map<String, String> toMap(Properties props) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (null != props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    protected Props() {
    }
}

