/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;

public class Randoms {
    private static final Random RANDOM = new Random();

    public static String nextString(int length) {
        return Randoms.nextString(length, 33, 127, false, false);
    }

    public static String nextString(int minLength, int maxLength) {
        int len = minLength == maxLength ? minLength : Randoms.nextInt(minLength, maxLength);
        return Randoms.nextString(len);
    }

    public static char nextCharacter() {
        return Randoms.nextString(1, true, true).charAt(0);
    }

    public static String nextString(int length, boolean letters, boolean numbers) {
        return Randoms.nextString(length, 0, 0, letters, numbers);
    }

    public static String nextString(int length, String chars) {
        if (chars == null) {
            return Randoms.nextString(length, 0, 0, false, false, null, RANDOM);
        }
        return Randoms.nextString(length, chars.toCharArray());
    }

    public static String nextString(int length, char ... chars) {
        if (chars == null) {
            return Randoms.nextString(length, 0, 0, false, false, null, RANDOM);
        }
        return Randoms.nextString(length, 0, chars.length, false, false, chars, RANDOM);
    }

    public static String nextStringAlphabetic(int length) {
        return Randoms.nextString(length, true, false);
    }

    public static String nextStringAlphanumeric(int length) {
        return Randoms.nextString(length, true, true);
    }

    public static String nextStringNumeric(int count) {
        return Randoms.nextString(count, false, true);
    }

    public static Date nextDateTime() {
        return new Date(Randoms.nextLong());
    }

    public static java.sql.Date nextDate() {
        return new java.sql.Date(Randoms.nextLong());
    }

    public static Time nextTime() {
        return new Time(Randoms.nextLong());
    }

    public static Timestamp nextTimestamp() {
        return new Timestamp(Randoms.nextLong());
    }

    public static short nextShort() {
        return (short)(RANDOM.nextDouble() * 32767.0);
    }

    public static short nextShort(short max) {
        return (short)(RANDOM.nextDouble() * (double)max);
    }

    public static int nextInt() {
        return (int)(RANDOM.nextDouble() * 2.147483647E9);
    }

    public static int nextInt(int max) {
        return (int)(RANDOM.nextDouble() * (double)max);
    }

    public static int nextInt(int min, int max) {
        return (int)(RANDOM.nextDouble() * (double)(max - min)) + min;
    }

    public static long nextLong() {
        return (long)(RANDOM.nextDouble() * 9.223372036854776E18);
    }

    public static long nextLong(long max) {
        return (long)(RANDOM.nextDouble() * (double)max);
    }

    public static long nextLong(long min, long max) {
        return (long)(RANDOM.nextDouble() * (double)(max - min)) + min;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat() * Float.MAX_VALUE;
    }

    public static float nextFloat(float max) {
        return RANDOM.nextFloat() * max;
    }

    public static double nextDouble() {
        return RANDOM.nextDouble() * Double.MAX_VALUE;
    }

    public static double nextDouble(double max) {
        return RANDOM.nextDouble() * max;
    }

    public static boolean nextBoolean() {
        return RANDOM.nextDouble() > 0.5;
    }

    static String nextString(int count, int start, int end, boolean letters, boolean numbers) {
        return Randoms.nextString(count, start, end, letters, numbers, null, RANDOM);
    }

    static String nextString(int count, int start, int end, boolean letters, boolean numbers, char ... chars) {
        return Randoms.nextString(count, start, end, letters, numbers, chars, RANDOM);
    }

    static String nextString(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    protected Randoms() {
    }
}

