/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.Serializable;
import leap.lang.exception.ReadonlyException;

public final class Readonly
implements Serializable {
    private static final long serialVersionUID = -5043085032440298812L;
    private boolean enabled;
    private String message;

    public Readonly() {
    }

    public Readonly(Object object) {
        this("Object '" + object.toString() + "' is readonly");
    }

    public Readonly(Class<?> cls) {
        this("Class '" + cls.getName() + "' is readonly");
    }

    public Readonly(String message) {
        this.message = message;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public Readonly check() throws ReadonlyException {
        if (this.enabled) {
            throw new ReadonlyException(null == this.message ? "object readonly" : this.message);
        }
        return this;
    }

    public Readonly check(String message) throws ReadonlyException {
        if (this.enabled) {
            throw new ReadonlyException(message);
        }
        return this;
    }
}

