/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

public interface Result<T> {
    public static final Result EMPTY = new Result(){

        public Object get() {
            return null;
        }
    };
    public static final Result INTERCEPTED = new Result(){

        public Object get() {
            return null;
        }

        @Override
        public boolean isIntercepted() {
            return true;
        }
    };

    public static <T> Result<T> empty() {
        return EMPTY;
    }

    public static <T> Result<T> intercepted() {
        return INTERCEPTED;
    }

    public static boolean empty(Result r) {
        return null != r && r.isEmpty();
    }

    public static boolean present(Result r) {
        return null != r && r.isPresent();
    }

    public static boolean intercepted(Result r) {
        return null != r && r.isIntercepted();
    }

    public static <T> T value(Result<T> r) {
        return null == r ? null : (T)r.get();
    }

    public static <T> Result<T> of(T value) {
        return () -> value;
    }

    public T get();

    default public boolean isEmpty() {
        return null == this.get() && !this.isIntercepted();
    }

    default public boolean isPresent() {
        return null != this.get();
    }

    default public boolean isIntercepted() {
        return false;
    }
}

