/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Charsets;
import leap.lang.Objects2;

public class Strings {
    public static final String EMPTY = "";
    public static final String NULL = "null";
    public static final String COMMA = ",";
    public static final char[] DEFAULT_SPLIT_CHARS = new char[]{','};

    public static String nullToEmpty(String string) {
        return null == string ? EMPTY : string;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isAllEmpty(String ... strings) {
        if (null == strings || strings.length == 0) {
            return true;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!Strings.isNotBlank(strings[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String string) {
        return null != string && string.length() > 0;
    }

    public static boolean isBlank(CharSequence string) {
        int strLen;
        if (string == null || (strLen = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        int strLen;
        if (string == null || (strLen = string.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof String) {
            return Strings.isEmpty((String)value);
        }
        return false;
    }

    public static boolean isNullOrBlank(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof String) {
            return Strings.isBlank((String)value);
        }
        return false;
    }

    public static boolean equals(String string1, String string2) {
        return string1 == null ? string2 == null : string1.equals(string2);
    }

    public static boolean equals(String string1, String string2, boolean ignoreCase) {
        return string1 == null ? string2 == null : (ignoreCase ? string1.equalsIgnoreCase(string2) : string1.equals(string2));
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        if (string1 == null || string2 == null) {
            return string1 == string2;
        }
        return string1.equalsIgnoreCase(string2);
    }

    public static int length(String s) {
        return null == s ? 0 : s.length();
    }

    public static int count(String str, char c) {
        if (null == str) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String firstNotEmpty(String ... strings) {
        for (String string : strings) {
            if (Strings.isEmpty(string)) continue;
            return string;
        }
        return EMPTY;
    }

    public static String format(String template, Object ... args) {
        if (Strings.isEmpty(template)) {
            return EMPTY;
        }
        if (null == args || args.length == 0) {
            return template;
        }
        char[] templateChars = template.toCharArray();
        int templateLength = templateChars.length;
        int length = 0;
        int tokenCount = args.length;
        for (int i = 0; i < tokenCount; ++i) {
            Object sourceString = args[i];
            if (sourceString == null) continue;
            length += sourceString.toString().length();
        }
        StringBuilder buffer = new StringBuilder(length + templateLength);
        int lastStart = 0;
        for (int i = 0; i < templateLength; ++i) {
            int tokenIndex;
            char ch = templateChars[i];
            if (ch != '{' || i + 2 >= templateLength || templateChars[i + 2] != '}' || (tokenIndex = templateChars[i + 1] - 48) < 0 || tokenIndex >= tokenCount) continue;
            buffer.append(templateChars, lastStart, i - lastStart);
            Object sourceString = args[tokenIndex];
            if (sourceString != null) {
                buffer.append(sourceString.toString());
            }
            lastStart = (i += 2) + 1;
        }
        buffer.append(templateChars, lastStart, templateLength - lastStart);
        return new String(buffer);
    }

    public static String trim(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String trimStart(String s) {
        int start;
        int strLen;
        if (s == null || (strLen = s.length()) == 0) {
            return EMPTY;
        }
        for (start = 0; start != strLen && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        return s.substring(start);
    }

    public static String trimStart(String str, char ... trimChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return EMPTY;
        }
        if (trimChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (trimChars.length == 0) {
                return str;
            }
            while (start != strLen && Arrays2.indexOf(trimChars, str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String trimEnd(String s) {
        int end;
        if (s == null || (end = s.length()) == 0) {
            return EMPTY;
        }
        while (end != 0 && Character.isWhitespace(s.charAt(end - 1))) {
            --end;
        }
        return s.substring(0, end);
    }

    public static String trimEnd(String str, char ... trimChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return EMPTY;
        }
        if (trimChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (trimChars.length == 0) {
                return str;
            }
            while (end != 0 && Arrays2.indexOf(trimChars, str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String trimToNull(String string) {
        if (null == string) {
            return null;
        }
        String ts = string.trim();
        return ts.length() == 0 ? null : ts;
    }

    public static String[] split(String string) {
        return Strings.splitWorker(string, 44, false, true, true, new char[0]);
    }

    public static String[] splitWhitespaces(String s) {
        String token;
        if (null == s || s.length() == 0) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int len = s.length();
        boolean match = false;
        while (i < len) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (match) {
                    token = s.substring(start, i).trim();
                    if (token.length() > 0) {
                        list.add(token);
                    }
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match && (token = s.substring(start, i).trim()).length() > 0) {
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitMultiLines(String string) {
        return Strings.splitWorker(string, -1, false, true, true, '\r', '\n');
    }

    public static String[] splitMultiLines(String string, char separator) {
        return Strings.splitWorker(string, -1, false, true, true, '\r', '\n', separator);
    }

    public static String[] split(String string, char separator) {
        return Strings.splitWorker(string, -1, false, true, true, separator);
    }

    public static String[] split(String string, char ... separators) {
        return Strings.splitWorker(string, -1, false, true, true, separators);
    }

    public static String[] split(String string, String separator) {
        return Strings.splitByWholeSeparatorWorker(string, separator, -1, false, true, true);
    }

    public static String[] split(String string, char separator, boolean trim) {
        return Strings.splitWorker(string, -1, false, trim, true, separator);
    }

    public static String[] split(String string, char[] separators, boolean trim) {
        return Strings.splitWorker(string, -1, false, trim, true, separators);
    }

    public static String[] split(String string, String separator, boolean trim) {
        return Strings.splitByWholeSeparatorWorker(string, separator, -1, false, trim, true);
    }

    public static String[] split(String string, String separator, boolean trim, boolean ignoreEmpty) {
        return Strings.splitByWholeSeparatorWorker(string, separator, -1, !ignoreEmpty, trim, ignoreEmpty);
    }

    public static String[] split(String string, char[] separators, boolean trim, boolean ignoreEmpty) {
        return Strings.splitWorker(string, -1, !ignoreEmpty, trim, ignoreEmpty, separators);
    }

    public static String replaceOnce(String text, String oldString, String newString) {
        return Strings.replace(text, oldString, newString, 1);
    }

    public static String replace(String text, String oldString, String newString) {
        return Strings.replace(text, oldString, newString, -1);
    }

    public static String replaceIgnoreCase(String text, String oldString, String newString) {
        return Strings.replaceIgnoreCase(text, oldString, newString, -1);
    }

    public static String replace(String text, char oldChar, char newChar) {
        if (text == null) {
            return EMPTY;
        }
        return text.replace(oldChar, newChar);
    }

    public static String remove(String string, String remove) {
        if (Strings.isEmpty(string)) {
            return EMPTY;
        }
        if (Strings.isEmpty(remove)) {
            return string;
        }
        return Strings.replace(string, remove, EMPTY, -1);
    }

    public static String remove(String string, char remove) {
        if (Strings.isEmpty(string)) {
            return EMPTY;
        }
        if (string.indexOf(remove) == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeBlank(String str) {
        if (Strings.isEmpty(str)) {
            return EMPTY;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static String removeStart(String string, String remove) {
        if (Strings.isEmpty(string)) {
            return EMPTY;
        }
        if (Strings.isEmpty(remove)) {
            return string;
        }
        if (string.startsWith(remove)) {
            return string.substring(remove.length());
        }
        return string;
    }

    public static String removeStartIgnoreCase(String string, String remove) {
        if (Strings.isEmpty(string)) {
            return EMPTY;
        }
        if (Strings.isEmpty(remove)) {
            return string;
        }
        if (Strings.startsWithIgnoreCase(string, remove)) {
            return string.substring(remove.length());
        }
        return string;
    }

    public static String removeEnd(String string, String remove) {
        if (Strings.isEmpty(string)) {
            return EMPTY;
        }
        if (Strings.isEmpty(remove)) {
            return string;
        }
        if (string.endsWith(remove)) {
            return string.substring(0, string.length() - remove.length());
        }
        return string;
    }

    public static String removeEndIgnoreCase(String str, String remove) {
        if (Strings.isEmpty(str)) {
            return EMPTY;
        }
        if (Strings.isEmpty(remove)) {
            return str;
        }
        if (Strings.endsWithIgnoreCase(str, remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String concat(String ... strs) {
        if (null == strs || strs.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            String s = strs[i];
            if (null == s || s.length() <= 0) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return EMPTY;
        }
        int len = array.length;
        StringBuilder buf = new StringBuilder(len * 16);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return EMPTY;
        }
        int len = array.length;
        StringBuilder buf = new StringBuilder(len * 16);
        for (int i = 0; i < len; ++i) {
            if (i > 0 && separator != null) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator, boolean ignoreEmpty) {
        if (!ignoreEmpty) {
            return Strings.join(array, separator);
        }
        if (array == null) {
            return EMPTY;
        }
        int len = array.length;
        StringBuilder buf = new StringBuilder(len * 16);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            Object value = array[i];
            if (Objects2.isEmpty(value)) continue;
            if (j > 0 && separator != null) {
                buf.append(separator);
            }
            buf.append(value);
            ++j;
        }
        return buf.toString();
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return EMPTY;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return EMPTY;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return EMPTY;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return EMPTY;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String upperFirst(String string) {
        if (null == string) {
            return EMPTY;
        }
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static String lowerFirst(String string) {
        if (null == string) {
            return EMPTY;
        }
        if (string.length() > 1) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static String upperCase(String string) {
        if (string == null) {
            return EMPTY;
        }
        return string.toUpperCase();
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return EMPTY;
        }
        return string.toLowerCase();
    }

    public static String lowerCamel(String string, char seperator) {
        if (null == string) {
            return EMPTY;
        }
        String[] parts = Strings.split(string, seperator);
        if (parts.length == 1) {
            return parts[0].substring(0, 1).toLowerCase() + parts[0].substring(1);
        }
        StringBuilder out = new StringBuilder(string.length());
        for (String part : parts) {
            if (out.length() == 0) {
                out.append(part.substring(0, 1).toLowerCase() + part.substring(1).toLowerCase());
                continue;
            }
            out.append(part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase());
        }
        return out.toString();
    }

    public static String lowerCamel(String ... parts) {
        StringBuilder out = new StringBuilder();
        for (String part : parts) {
            if (null == part || part.length() == 0) continue;
            if (out.length() == 0) {
                out.append(part.toLowerCase());
                continue;
            }
            out.append(part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase());
        }
        return out.toString();
    }

    public static String upperCamel(String string, char seperator) {
        if (null == string) {
            return EMPTY;
        }
        String[] parts = Strings.split(string, seperator);
        if (parts.length == 1) {
            return parts[0].substring(0, 1).toUpperCase() + parts[0].substring(1);
        }
        StringBuilder out = new StringBuilder();
        for (String part : parts) {
            if (part.length() == 0) continue;
            out.append(part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase());
        }
        return out.toString();
    }

    public static String upperCamel(String ... parts) {
        StringBuilder out = new StringBuilder();
        for (String part : parts) {
            if (null == part || part.length() == 0) continue;
            out.append(part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase());
        }
        return out.toString();
    }

    public static String lowerUnderscore(String name) {
        return Strings.lowerSplit(name, '_');
    }

    public static String lowerHyphen(String name) {
        return Strings.lowerSplit(name, '-');
    }

    protected static String lowerSplit(String name, char c) {
        StringBuilder buf = new StringBuilder(name);
        for (int i = 1; i < buf.length() - 1; ++i) {
            char p = buf.charAt(i - 1);
            if (!Character.isLowerCase(p) && !Character.isDigit(p) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, c);
        }
        return buf.toString().toLowerCase();
    }

    public static boolean startsWith(String string, String startsWith) {
        return Strings.startsWith(string, startsWith, false);
    }

    public static boolean startsWithIgnoreCase(String string, String startsWith) {
        return Strings.startsWith(string, startsWith, true);
    }

    public static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWith(String string, String endsWith) {
        return Strings.endsWith(string, endsWith, false);
    }

    public static boolean endsWithIgnoreCase(String string, String endsWith) {
        return Strings.endsWith(string, endsWith, true);
    }

    public static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean contains(String string, char c) {
        if (null == string) {
            return false;
        }
        return string.indexOf(c) >= 0;
    }

    public static boolean contains(String string, String contains) {
        return Strings.indexOf(string, contains) >= 0;
    }

    public static boolean containsWhitespaces(CharSequence cs) {
        if (null == cs) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (!Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String string, String contains) {
        if (null == string || null == contains) {
            return false;
        }
        int len = contains.length();
        int max = string.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!string.regionMatches(true, i, contains, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(String string, String indexOf) {
        if (null == string || null == indexOf) {
            return -1;
        }
        return string.indexOf(indexOf);
    }

    public static int indexOf(String string, String indexOf, int fromIndex) {
        if (null == string || null == indexOf) {
            return -1;
        }
        return string.indexOf(indexOf, fromIndex);
    }

    public static int indexOfIgnoreCase(String string, String indexOf) {
        return Strings.indexOfIgnoreCase(string, indexOf, 0);
    }

    public static int indexOfIgnoreCase(String string, String indexOf, int fromIndex) {
        int endLimit;
        if (string == null || indexOf == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = string.length() - indexOf.length() + 1)) {
            return -1;
        }
        if (indexOf.length() == 0) {
            return fromIndex;
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!string.regionMatches(true, i, indexOf, 0, indexOf.length())) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String string, String indexOf) {
        if (null == string || null == indexOf) {
            return -1;
        }
        return string.lastIndexOf(indexOf);
    }

    public static int lastIndexOf(String string, String indexOf, int fromIndex) {
        if (null == string || null == indexOf) {
            return -1;
        }
        return string.lastIndexOf(indexOf, fromIndex);
    }

    public static int lastIndexOfIgnoreCase(String string, String indexOf) {
        return Strings.lastIndexOfIgnoreCase(string, indexOf, -1);
    }

    public static int lastIndexOfIgnoreCase(String string, String indexOf, int fromIndex) {
        if (string == null || indexOf == null) {
            return -1;
        }
        if (fromIndex == -1 || fromIndex > string.length() - indexOf.length()) {
            fromIndex = string.length() - indexOf.length();
        }
        if (fromIndex < 0) {
            return -1;
        }
        if (indexOf.length() == 0) {
            return fromIndex;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!string.regionMatches(true, i, indexOf, 0, indexOf.length())) continue;
            return i;
        }
        return -1;
    }

    public static String substringBefore(String string, String indexOf) {
        if (null == string || null == indexOf) {
            return EMPTY;
        }
        int index = string.indexOf(indexOf);
        if (index < 0) {
            return EMPTY;
        }
        return string.substring(0, index);
    }

    public static String substringAfter(String string, String indexOf) {
        if (null == string || null == indexOf) {
            return EMPTY;
        }
        int index = string.indexOf(indexOf);
        if (index < 0) {
            return EMPTY;
        }
        return string.substring(index + 1);
    }

    public static String left(String string, int len) {
        if (string == null) {
            return EMPTY;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (string.length() <= len) {
            return string;
        }
        return string.substring(0, len);
    }

    public static String right(String string, int len) {
        if (string == null) {
            return EMPTY;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (string.length() <= len) {
            return string;
        }
        return string.substring(string.length() - len);
    }

    public static String abbreviate(String str, int maxWidth) {
        return Strings.abbreviate(str, 0, maxWidth, "...");
    }

    public static String abbreviate(String str, int maxWidth, String abrevMarker) {
        return Strings.abbreviate(str, 0, maxWidth, abrevMarker);
    }

    public static String abbreviateMiddle(String str, int maxWidth) {
        return Strings.abbreviateMiddle(str, "...", maxWidth);
    }

    static String abbreviate(String str, int offset, int maxWidth, String abrevMarker) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + abrevMarker;
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            return abrevMarker + Strings.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return abrevMarker + str.substring(str.length() - (maxWidth - 3));
    }

    public static String abbreviateMiddle(String str, String middle, int length) {
        if (Strings.isEmpty(str) || Strings.isEmpty(middle)) {
            return str;
        }
        if (length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int targetSting = length - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str.length() - targetSting / 2;
        StringBuilder builder = new StringBuilder(length);
        builder.append(str.substring(0, startOffset));
        builder.append(middle);
        builder.append(str.substring(endOffset));
        return builder.toString();
    }

    public static String abbreviatePrefix(String str, int prefixLength, int length, String abrevMarker) {
        if (Strings.isEmpty(str) || Strings.isEmpty(abrevMarker)) {
            return str;
        }
        if (length >= str.length() || prefixLength > str.length()) {
            return str;
        }
        int fullPrefixLength = prefixLength + abrevMarker.length();
        StringBuilder builder = new StringBuilder(length);
        builder.append(str.substring(0, prefixLength));
        builder.append(abrevMarker);
        if (fullPrefixLength < length) {
            int startOffset = str.length() - length + fullPrefixLength;
            builder.append(str.substring(startOffset));
        }
        return builder.toString();
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String repeat(String string, int count) {
        int n;
        if (null == string) {
            return EMPTY;
        }
        if (count <= 1) {
            Args.assertTrue(count >= 0, "invalid count: " + count);
            return count == 0 ? EMPTY : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(longSize));
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static boolean isDigits(String cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetters(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLetter(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (Strings.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static String newStringIso8859_1(byte[] bytes) {
        return Strings.newString(bytes, Charsets.ISO_8859_1.name());
    }

    public static String newStringUsAscii(byte[] bytes) {
        return Strings.newString(bytes, Charsets.US_ASCII.name());
    }

    public static String newStringUtf8(byte[] bytes) {
        return Strings.newString(bytes, Charsets.UTF_8.name());
    }

    public static byte[] getBytes(String str, String charset) {
        if (Strings.isEmpty(str)) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static byte[] getBytesIso8859_1(String string) {
        return Strings.getBytes(string, Charsets.ISO_8859_1.name());
    }

    public static byte[] getBytesUsAscii(String string) {
        return Strings.getBytes(string, Charsets.US_ASCII.name());
    }

    public static byte[] getBytesUtf8(String string) {
        return Strings.getBytes(string, Charsets.UTF_8.name());
    }

    private static String[] splitWorker(String str, int max, boolean preserveAllTokens, boolean trimTokens, boolean ignoreEmptyTokens, char ... chars) {
        int len;
        if (str == null) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        if (null == chars || chars.length == 0) {
            chars = DEFAULT_SPLIT_CHARS;
        }
        if ((len = str.length()) == 0) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (chars.length == 1) {
            char sep = chars[0];
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        String token = str.substring(start, i);
                        if (trimTokens) {
                            token = Strings.trim(token);
                        }
                        if (!ignoreEmptyTokens || token.length() > 0) {
                            list.add(token);
                        }
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (Arrays2.indexOf(chars, str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        String token = str.substring(start, i);
                        if (trimTokens) {
                            token = Strings.trim(token);
                        }
                        if (!ignoreEmptyTokens || token.length() > 0) {
                            list.add(token);
                        }
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            String token = str.substring(start, i);
            if (trimTokens) {
                token = Strings.trim(token);
            }
            if (!ignoreEmptyTokens || token.length() > 0) {
                list.add(token);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] splitByWholeSeparatorWorker(String str, String separator, int max, boolean preserveAllTokens, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Arrays2.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return Strings.splitWorker(str, max, preserveAllTokens, trimTokens, ignoreEmptyTokens, new char[0]);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            String token = null;
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        token = str.substring(beg);
                    } else {
                        token = str.substring(beg, end);
                        beg = end + separatorLength;
                    }
                } else {
                    if (preserveAllTokens) {
                        if (++numberOfSubstrings == max) {
                            end = len;
                            token = str.substring(beg);
                        } else {
                            token = EMPTY;
                        }
                    }
                    beg = end + separatorLength;
                }
            } else {
                token = str.substring(beg);
                end = len;
            }
            if (null == token) continue;
            if (trimTokens) {
                token = Strings.trim(token);
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            substrings.add(token);
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    private static String replace(String text, String oldString, String newString, int max) {
        if (Strings.isEmpty(text) || Strings.isEmpty(oldString) || newString == null || max == 0) {
            return Strings.nullToEmpty(text);
        }
        int start = 0;
        int end = text.indexOf(oldString, start);
        if (end == -1) {
            return text;
        }
        int replLength = oldString.length();
        int increase = newString.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(newString);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(oldString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    private static String replaceIgnoreCase(String text, String oldString, String newString, int max) {
        int start;
        String lcOldString;
        if (Strings.isEmpty(text) || Strings.isEmpty(oldString) || newString == null || max == 0) {
            return Strings.nullToEmpty(text);
        }
        String lcText = text.toLowerCase();
        int end = lcText.indexOf(lcOldString = oldString.toLowerCase(), start = 0);
        if (end == -1) {
            return lcText;
        }
        int replLength = lcOldString.length();
        int increase = newString.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(lcText.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(newString);
            start = end + replLength;
            if (--max == 0) break;
            end = lcText.indexOf(lcOldString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    protected Strings() {
    }
}

