/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.util.function.Consumer;
import leap.lang.Exceptions;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class Try {
    private static final Log log = LogFactory.get(Try.class);

    public static void catchAll(CatchRunnable runnable, Consumer<Throwable> errorHandler) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            errorHandler.accept(e);
        }
    }

    public static void catchAll(CatchRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            log.warn(e);
        }
    }

    public static void throwUnchecked(CatchRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static <T> T throwUncheckedWithResult(CatchSupplier<T> supplier) {
        try {
            return supplier.run();
        }
        catch (Throwable e) {
            throw Exceptions.uncheck(e);
        }
    }

    protected Try() {
    }

    public static interface CatchSupplier<T> {
        public T run() throws Throwable;
    }

    public static interface CatchRunnable {
        public void run() throws Throwable;
    }
}

