/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.lang.reflect.Type;
import java.util.Map;
import leap.lang.Args;
import leap.lang.meta.MTypeKind;

public class TypeInfo {
    private final Class<?> type;
    private final Type genericType;
    private final MTypeKind typeKind;
    private final Class<?> elementType;
    private final TypeInfo elementTypeInfo;

    public TypeInfo(Class<?> type, Type genericType, MTypeKind kind, Class<?> elementType, TypeInfo elementTypeInfo) {
        Args.notNull(type, "type");
        Args.notNull(kind, "kind");
        if (null != elementType) {
            Args.assertTrue(kind == MTypeKind.COLLECTION, "The element type must not be null if the kind is 'COLLECTION'");
            Args.assertTrue(elementTypeInfo != null, "The element type info must not be null if the element type is not null");
        } else {
            Args.assertFalse(kind == MTypeKind.COLLECTION, "The element type must be null if the kind is not 'COLLECTION'");
            Args.assertTrue(elementTypeInfo == null, "The element type info must be null if the element type is null");
        }
        this.type = type;
        this.genericType = genericType;
        this.typeKind = kind;
        this.elementType = elementType;
        this.elementTypeInfo = elementTypeInfo;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public MTypeKind getTypeKind() {
        return this.typeKind;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public TypeInfo getElementTypeInfo() {
        return this.elementTypeInfo;
    }

    public boolean isSimpleType() {
        return this.typeKind == MTypeKind.SIMPLE;
    }

    public boolean isComplexType() {
        return this.typeKind == MTypeKind.COMPLEX;
    }

    public boolean isMap() {
        return this.type == Map.class;
    }

    public boolean isSimpleElementType() {
        return null != this.elementTypeInfo && this.elementTypeInfo.isSimpleType();
    }

    public boolean isComplexElementType() {
        return null != this.elementTypeInfo && this.elementTypeInfo.isComplexType();
    }

    public boolean isCollectionType() {
        return this.typeKind == MTypeKind.COLLECTION;
    }
}

