/*
 * Decompiled with CFR 0.152.
 */
package leap.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.Primitives;
import leap.lang.TypeInfo;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MTypeKind;

public class Types {
    protected static final Type[] EMPTY_TYPES = new Type[0];

    public static TypeInfo getTypeInfo(Class<?> type) {
        return Types.getTypeInfo(type, null);
    }

    public static TypeInfo getTypeInfo(Class<?> type, Type genericType) {
        MTypeKind kind = null;
        Class<?> elementType = null;
        TypeInfo elementTypeInfo = null;
        if (Types.isSimpleType(type, genericType)) {
            kind = MTypeKind.SIMPLE;
        } else if (Types.isCollectionType(type, genericType)) {
            kind = MTypeKind.COLLECTION;
            elementType = Types.getElementType(type, genericType);
            elementTypeInfo = Types.getTypeInfo(elementType, null);
        } else {
            kind = MTypeKind.COMPLEX;
        }
        return new TypeInfo(type, genericType, kind, elementType, elementTypeInfo);
    }

    public static boolean isSimpleType(Class<?> type, Type genericType) {
        return MSimpleTypes.tryForClass(type) != null;
    }

    public static boolean isCollectionType(Class<?> type, Type genericType) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    public static Class<?> getElementType(Class<?> type, Type genericType) throws IllegalStateException {
        if (!Types.isCollectionType(type, genericType)) {
            throw new IllegalStateException("The given type '" + type + "' is not a collection type");
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (null == genericType) {
            return Object.class;
        }
        return Types.getActualTypeArgument(genericType);
    }

    public static Type getTypeArgument(Type genericType) {
        Type[] types = Types.getTypeArguments(genericType);
        if (types.length == 0) {
            return Object.class;
        }
        if (types.length == 1) {
            Type type = types[0];
            if (type instanceof WildcardType) {
                types = ((WildcardType)type).getUpperBounds();
                if (types.length != 1) {
                    throw new IllegalArgumentException("Found multi upper bounds at type argument '" + type + "'");
                }
                type = types[0];
            }
            return type;
        }
        throw new IllegalArgumentException("Found multi type arguments of '" + genericType + "'");
    }

    public static Type[] getTypeArguments(Type genericType) {
        Args.notNull(genericType);
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments();
        }
        if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            return clazz.getTypeParameters();
        }
        return EMPTY_TYPES;
    }

    public static Class<?> getActualTypeArgument(Class<?> declaringClass, Type genericType) {
        if (null == declaringClass) {
            return Types.getActualTypeArgument(genericType);
        }
        return Types.getActualType(declaringClass, Types.getTypeArgument(genericType));
    }

    public static Class<?> getActualType(Class<?> declaringClass, Type type) {
        if (null == declaringClass) {
            return Types.getActualType(type);
        }
        if (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            Class<?> actualType = Types.getActualType(declaringClass.getGenericSuperclass(), var);
            if (null != actualType) {
                return actualType;
            }
            for (Type genericInterface : declaringClass.getGenericInterfaces()) {
                actualType = Types.getActualType(genericInterface, var);
                if (null == actualType) continue;
                return actualType;
            }
        }
        return Types.getActualType(type);
    }

    protected static Class<?> getActualType(Type type, TypeVariable var) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < vars.length; ++i) {
                if (!vars[i].equals(var)) continue;
                return Types.getActualType(typeArgs[i]);
            }
        }
        return null;
    }

    public static Class<?> getActualTypeArgument(Type genericType) {
        Type type = Types.getTypeArgument(genericType);
        return type == Object.class ? Object.class : Types.getActualType(type);
    }

    public static Class<?>[] getActualTypeArguments(Type genericType) {
        return Types.getActualTypes(Types.getTypeArguments(genericType));
    }

    public static Class<?> getActualType(Type type) {
        Type[] types;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable && (types = ((TypeVariable)type).getBounds()).length == 1) {
            return Types.getActualType(types[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = Types.getActualType(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        return null;
    }

    public static Class<?>[] getActualTypes(Type[] types) {
        Class[] actualTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            actualTypes[i] = Types.getActualType(types[i]);
        }
        return actualTypes;
    }

    public static boolean isAssignable(Type type, Type toType) {
        return Types.isAssignable(type, toType, null);
    }

    static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        return Types.getTypeArguments(type, toClass, null);
    }

    static Class<?> getRawType(Type type, Type assigningType) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            if (assigningType == null) {
                return null;
            }
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (!(genericDeclaration instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> typeVarAssigns = Types.getTypeArguments(assigningType, (Class)genericDeclaration);
            if (typeVarAssigns == null) {
                return null;
            }
            Type typeArgument = typeVarAssigns.get(type);
            if (typeArgument == null) {
                return null;
            }
            return Types.getRawType(typeArgument, assigningType);
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = Types.getRawType(((GenericArrayType)type).getGenericComponentType(), assigningType);
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        if (type instanceof Class) {
            return Types.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
        }
        if (type instanceof ParameterizedType) {
            return Types.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return Types.getTypeArguments(((GenericArrayType)type).getGenericComponentType(), toClass.isArray() ? toClass.getComponentType() : toClass, subtypeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type bound : Types.getImplicitUpperBounds((WildcardType)type)) {
                if (!Types.isAssignable(bound, toClass)) continue;
                return Types.getTypeArguments(bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            for (Type bound : Types.getImplicitBounds((TypeVariable)type)) {
                if (!Types.isAssignable(bound, toClass)) continue;
                return Types.getTypeArguments(bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap<TypeVariable<?>, Type> typeVarAssigns;
        Class<?> cls = Types.getRawType(parameterizedType);
        if (!Types.isAssignable(cls, toClass)) {
            return null;
        }
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
            typeVarAssigns = Types.getTypeArguments(parameterizedOwnerType, Types.getRawType(parameterizedOwnerType), subtypeVarAssigns);
        } else {
            typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            Type typeArg = typeArgs[i];
            typeVarAssigns.put(typeParams[i], typeVarAssigns.containsKey(typeArg) ? (Type)typeVarAssigns.get(typeArg) : typeArg);
        }
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return Types.getTypeArguments(Types.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap typeVarAssigns;
        if (!Types.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = Primitives.wrap(cls);
        }
        HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (cls.getTypeParameters().length > 0 || toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return Types.getTypeArguments(Types.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superType) {
        Class<?> superClass = Types.getRawType(superType);
        if (!Types.isAssignable(cls, superClass)) {
            return null;
        }
        if (cls.equals(superClass)) {
            return Types.getTypeArguments(superType, superClass, null);
        }
        Type midType = Types.getClosestParentType(cls, superClass);
        if (midType instanceof Class) {
            return Types.determineTypeArguments((Class)midType, superType);
        }
        ParameterizedType midParameterizedType = (ParameterizedType)midType;
        Class<?> midClass = Types.getRawType(midParameterizedType);
        Map<TypeVariable<?>, Type> typeVarAssigns = Types.determineTypeArguments(midClass, superType);
        Types.mapTypeVariablesToArguments(cls, midParameterizedType, typeVarAssigns);
        return typeVarAssigns;
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            Types.mapTypeVariablesToArguments(cls, (ParameterizedType)ownerType, typeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVars = Types.getRawType(parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
        for (int i = 0; i < typeArgs.length; ++i) {
            TypeVariable<Class<?>> typeVar = typeVars[i];
            Type typeArg = typeArgs[i];
            if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
            typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
        }
    }

    private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        if (superClass.isInterface()) {
            Type[] interfaceTypes = cls.getGenericInterfaces();
            Type genericInterface = null;
            for (Type midType : interfaceTypes) {
                Class midClass = null;
                if (midType instanceof ParameterizedType) {
                    midClass = Types.getRawType((ParameterizedType)midType);
                } else if (midType instanceof Class) {
                    midClass = (Class)midType;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                }
                if (!Types.isAssignable((Type)midClass, superClass) || !Types.isAssignable(genericInterface, (Type)midClass)) continue;
                genericInterface = midType;
            }
            if (genericInterface != null) {
                return genericInterface;
            }
        }
        return cls.getGenericSuperclass();
    }

    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (toType == null || toType instanceof Class) {
            return Types.isAssignable(type, (Class)toType);
        }
        if (toType instanceof ParameterizedType) {
            return Types.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return Types.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return Types.isAssignable(type, (WildcardType)toType, typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            return Types.isAssignable(type, (TypeVariable)toType, typeVarAssigns);
        }
        throw new IllegalStateException("found an unhandled type: " + toType);
    }

    private static boolean isAssignable(Type type, Class<?> toClass) {
        if (type == null) {
            return toClass == null || !toClass.isPrimitive();
        }
        if (toClass == null) {
            return false;
        }
        if (toClass.equals(type)) {
            return true;
        }
        if (type instanceof Class) {
            return Classes.isAssignable((Class)type, toClass);
        }
        if (type instanceof ParameterizedType) {
            return Types.isAssignable(Types.getRawType((ParameterizedType)type), toClass);
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                if (!Types.isAssignable(bound, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return toClass.equals(Object.class) || toClass.isArray() && Types.isAssignable(((GenericArrayType)type).getGenericComponentType(), toClass.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toParameterizedType == null) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class<?> toClass = Types.getRawType(toParameterizedType);
        Map<TypeVariable<?>, Type> fromTypeVarAssigns = Types.getTypeArguments(type, toClass, null);
        if (fromTypeVarAssigns == null) {
            return false;
        }
        if (fromTypeVarAssigns.isEmpty()) {
            return true;
        }
        Map<TypeVariable<?>, Type> toTypeVarAssigns = Types.getTypeArguments(toParameterizedType, toClass, typeVarAssigns);
        for (Map.Entry<TypeVariable<?>, Type> entry : toTypeVarAssigns.entrySet()) {
            Type toTypeArg = entry.getValue();
            Type fromTypeArg = fromTypeVarAssigns.get(entry.getKey());
            if (fromTypeArg == null || toTypeArg.equals(fromTypeArg) || toTypeArg instanceof WildcardType && Types.isAssignable(fromTypeArg, toTypeArg, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toGenericArrayType == null) {
            return false;
        }
        if (toGenericArrayType.equals(type)) {
            return true;
        }
        Type toComponentType = toGenericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() && Types.isAssignable(cls.getComponentType(), toComponentType, typeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return Types.isAssignable(((GenericArrayType)type).getGenericComponentType(), toComponentType, typeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type bound : Types.getImplicitUpperBounds((WildcardType)type)) {
                if (!Types.isAssignable(bound, toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof TypeVariable) {
            for (Type bound : Types.getImplicitBounds((TypeVariable)type)) {
                if (!Types.isAssignable(bound, toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toWildcardType == null) {
            return false;
        }
        if (toWildcardType.equals(type)) {
            return true;
        }
        Type[] toUpperBounds = Types.getImplicitUpperBounds(toWildcardType);
        Type[] toLowerBounds = Types.getImplicitLowerBounds(toWildcardType);
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = Types.getImplicitUpperBounds(wildcardType);
            Type[] lowerBounds = Types.getImplicitLowerBounds(wildcardType);
            for (Type toBound : toUpperBounds) {
                toBound = Types.substituteTypeVariables(toBound, typeVarAssigns);
                for (Type bound : upperBounds) {
                    if (Types.isAssignable(bound, toBound, typeVarAssigns)) continue;
                    return false;
                }
            }
            for (Type toBound : toLowerBounds) {
                toBound = Types.substituteTypeVariables(toBound, typeVarAssigns);
                for (Type bound : lowerBounds) {
                    if (Types.isAssignable(toBound, bound, typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }
        for (Type toBound : toUpperBounds) {
            if (Types.isAssignable(type, Types.substituteTypeVariables(toBound, typeVarAssigns), typeVarAssigns)) continue;
            return false;
        }
        for (Type toBound : toLowerBounds) {
            if (Types.isAssignable(Types.substituteTypeVariables(toBound, typeVarAssigns), type, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toTypeVariable == null) {
            return false;
        }
        if (toTypeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] bounds;
            for (Type bound : bounds = Types.getImplicitBounds((TypeVariable)type)) {
                if (!Types.isAssignable(bound, toTypeVariable, typeVarAssigns)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type instanceof TypeVariable && typeVarAssigns != null) {
            Type replacementType = typeVarAssigns.get(type);
            if (replacementType == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return replacementType;
        }
        return type;
    }

    static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Type[] typeArray;
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = Types.normalizeUpperBounds(bounds);
        }
        return typeArray;
    }

    static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Type[] bounds = wildcardType.getUpperBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = Types.normalizeUpperBounds(bounds);
        }
        return typeArray;
    }

    static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Type[] bounds = wildcardType.getLowerBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = null;
        } else {
            typeArray = bounds;
        }
        return typeArray;
    }

    static Type[] normalizeUpperBounds(Type[] bounds) {
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> types = new HashSet<Type>(bounds.length);
        for (Type type1 : bounds) {
            boolean subtypeFound = false;
            for (Type type2 : bounds) {
                if (type1 == type2 || !Types.isAssignable(type2, type1, null)) continue;
                subtypeFound = true;
                break;
            }
            if (subtypeFound) continue;
            types.add(type1);
        }
        return types.toArray(new Type[types.size()]);
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("parameterizedType.getRawType() returned not a Class object");
        }
        return (Class)rawType;
    }

    protected Types() {
    }
}

