/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.accessor;

import java.math.BigDecimal;
import leap.lang.Objects2;
import leap.lang.convert.Converts;

public interface IndexedGetter {
    public <T> T get(int var1) throws IndexOutOfBoundsException;

    default public <T> T get(int index, Class<T> type) throws IndexOutOfBoundsException {
        T v = this.get(index);
        return Objects2.isEmpty(v) ? null : (T)Converts.convert(v, type);
    }

    default public <T> T get(int index, Class<T> type, T defaultValue) throws IndexOutOfBoundsException {
        T v = this.get(index);
        return Objects2.isEmpty(v) ? defaultValue : Converts.convert(v, type);
    }

    default public String getString(int index) {
        return this.get(index, String.class);
    }

    default public Short getShort(int index) {
        return this.get(index, Short.class);
    }

    default public short getShort(int index, short defaultValue) {
        return this.get(index, Short.class, defaultValue);
    }

    default public Integer getInteger(int index) {
        return this.get(index, Integer.class);
    }

    default public int getInteger(int index, int defaultValue) {
        return this.get(index, Integer.class, defaultValue);
    }

    default public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    default public long getLong(int index, long defaultValue) {
        return this.get(index, Long.class, defaultValue);
    }

    default public Float getFloat(int index) {
        return this.get(index, Float.class);
    }

    default public float getFloat(int index, float defaultValue) {
        return this.get(index, Float.class, Float.valueOf(defaultValue)).floatValue();
    }

    default public Double getDouble(int index) {
        return this.get(index, Double.class);
    }

    default public double getDouble(int index, double defaultValue) {
        return this.get(index, Double.class, defaultValue);
    }

    default public BigDecimal getDecimal(int index) {
        return this.get(index, BigDecimal.class);
    }
}

