/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.accessor;

import java.math.BigDecimal;
import leap.lang.Named;
import leap.lang.Objects2;
import leap.lang.convert.Converts;
import leap.lang.exception.ObjectNotFoundException;

public interface NamedGetter {
    public boolean contains(String var1);

    default public NamedGetter mustContains(String name) throws ObjectNotFoundException {
        if (!this.contains(name)) {
            throw new ObjectNotFoundException("The name '" + name + "' not exists!");
        }
        return this;
    }

    public <T> T get(String var1);

    default public <T> T mustGet(String name) {
        return this.mustContains(name).get(name);
    }

    default public <T> T get(Named named) {
        return this.get(named.getName());
    }

    default public <T> T get(String name, Class<T> type) {
        T v = this.get(name);
        return Objects2.isEmpty(v) ? null : (T)Converts.convert(v, type);
    }

    default public <T> T get(Named named, Class<T> type) {
        T v = this.get(named.getName());
        return Objects2.isEmpty(v) ? null : (T)Converts.convert(v, type);
    }

    default public <T> T get(String name, Class<T> type, T defaultValue) {
        T v = this.get(name);
        return Objects2.isEmpty(v) ? defaultValue : Converts.convert(v, type);
    }

    default public String getString(String name) {
        return this.get(name, String.class);
    }

    default public Short getShort(String name) {
        return this.get(name, Short.class);
    }

    default public short getShort(String name, short defaultValue) {
        return this.get(name, Short.class, defaultValue);
    }

    default public Integer getInteger(String name) {
        return this.get(name, Integer.class);
    }

    default public int getInteger(String name, int defaultValue) {
        return this.get(name, Integer.class, defaultValue);
    }

    default public Long getLong(String name) {
        return this.get(name, Long.class);
    }

    default public long getLong(String name, long defaultValue) {
        return this.get(name, Long.class, defaultValue);
    }

    default public Float getFloat(String name) {
        return this.get(name, Float.class);
    }

    default public float getFloat(String name, float defaultValue) {
        return this.get(name, Float.class, Float.valueOf(defaultValue)).floatValue();
    }

    default public Double getDouble(String name) {
        return this.get(name, Double.class);
    }

    default public double getDouble(String name, double defaultValue) {
        return this.get(name, Double.class, defaultValue);
    }

    default public BigDecimal getDecimal(String name) {
        return this.get(name, BigDecimal.class);
    }
}

