/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.asm;

import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.Collections2;
import leap.lang.Enums;
import leap.lang.Try;
import leap.lang.asm.ClassReader;
import leap.lang.asm.ClassVisitor;
import leap.lang.asm.ClassWriter;
import leap.lang.asm.MethodVisitor;
import leap.lang.asm.Type;
import leap.lang.asm.tree.AbstractInsnNode;
import leap.lang.asm.tree.AnnotationNode;
import leap.lang.asm.tree.ClassNode;
import leap.lang.asm.tree.FieldNode;
import leap.lang.asm.tree.InsnNode;
import leap.lang.asm.tree.MethodNode;
import leap.lang.asm.util.ASMifier;
import leap.lang.asm.util.ASMifier1;
import leap.lang.asm.util.Printer;
import leap.lang.asm.util.TraceClassVisitor;
import leap.lang.asm.util.TraceMethodVisitor;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;

public class ASM {
    public static final int API = 327680;
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INIT_NAME = "<clinit>";

    public static String opcodeName(int opcode) {
        return Printer.OPCODES[opcode];
    }

    public static MethodVisitor visitMethod(ClassVisitor cv, MethodNode m) {
        return cv.visitMethod(m.access, m.name, m.desc, m.signature, Collections2.toStringArray(m.exceptions));
    }

    public static boolean isConstructor(MethodNode m) {
        return m.name.equals(CONSTRUCTOR_NAME);
    }

    public static boolean isStaticInit(MethodNode m) {
        return m.name.equals(STATIC_INIT_NAME);
    }

    public static boolean isStatic(MethodNode m) {
        return Modifier.isStatic(m.access);
    }

    public static boolean isAnnotationPresent(MethodNode m, Class<? extends Annotation> annotationType) {
        if (null == m.visibleAnnotations) {
            return false;
        }
        String desc = Type.getDescriptor(annotationType);
        for (AnnotationNode an : m.visibleAnnotations) {
            if (!an.desc.equals(desc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(ClassNode n, Class<? extends Annotation> annotationType) {
        if (null == n.visibleAnnotations) {
            return false;
        }
        String desc = Type.getDescriptor(annotationType);
        for (AnnotationNode an : n.visibleAnnotations) {
            if (!an.desc.equals(desc)) continue;
            return true;
        }
        return false;
    }

    public static ClassNode getClassNode(ClassReader cr) {
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        return cn;
    }

    public static MethodNode getMethod(ClassNode cn, String name, String desc) {
        MethodNode m = ASM.tryGetMethod(cn, name, desc);
        if (null == m) {
            throw new ObjectNotFoundException("MethodNode '" + name + " " + desc + "' not found in class '" + cn.name + "'");
        }
        return m;
    }

    public static MethodNode tryGetMethod(ClassNode cn, String name, String desc) {
        if (null == cn.methods) {
            return null;
        }
        for (MethodNode m : cn.methods) {
            if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
            return m;
        }
        return null;
    }

    public static FieldNode getField(ClassNode cn, String name) {
        FieldNode f = ASM.tryGetField(cn, name);
        if (null == f) {
            throw new ObjectNotFoundException("FieldNode '" + name + "' not found in class '" + cn.name + "'");
        }
        return f;
    }

    public static FieldNode tryGetField(ClassNode cn, String name) {
        if (null == cn.fields) {
            return null;
        }
        for (FieldNode f : cn.fields) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        return null;
    }

    public static MethodNode[] getMethods(ClassNode cn, Predicate<MethodNode> predicate) {
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode m : cn.methods) {
            if (!predicate.test(m)) continue;
            methods.add(m);
        }
        return methods.toArray(new MethodNode[methods.size()]);
    }

    public static AnnotationNode getAnnotation(ClassNode m, Class<? extends Annotation> annotationType) {
        AnnotationNode a = ASM.getAnnotation(m.visibleAnnotations, annotationType);
        if (null == a) {
            a = ASM.getAnnotation(m.invisibleAnnotations, annotationType);
        }
        return a;
    }

    public static AnnotationNode getAnnotation(MethodNode m, Class<? extends Annotation> annotationType) {
        AnnotationNode a = ASM.getAnnotation(m.visibleAnnotations, annotationType);
        if (null == a) {
            a = ASM.getAnnotation(m.invisibleAnnotations, annotationType);
        }
        return a;
    }

    public static Map<String, Object> getAnnotationValues(AnnotationNode a) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (null != a.values) {
            for (int i = 0; i < a.values.size(); ++i) {
                String name = (String)a.values.get(i);
                Object value = a.values.get(i + 1);
                if (value instanceof String[]) {
                    String[] array = (String[])value;
                    Class<?> enumType = Classes.forName(Type.getType(array[0]).getClassName());
                    map.put(name, Enums.nameOf(enumType, array[1]));
                } else {
                    map.put(name, value);
                }
                ++i;
            }
        }
        return map;
    }

    private static AnnotationNode getAnnotation(List<AnnotationNode> annotations, Class<? extends Annotation> annotationType) {
        String desc = Type.getDescriptor(annotationType);
        if (null != annotations) {
            for (AnnotationNode a : annotations) {
                if (!a.desc.equals(desc)) continue;
                return a;
            }
        }
        return null;
    }

    public static String getObjectTypeDescriptor(String className) {
        return "L" + className.replace('.', '/') + ";";
    }

    public static Class<?> getClassType(String internalName) {
        return ASM.getClassType(Type.getObjectType(internalName));
    }

    public static Class<?> getClassType(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
        }
        String cn = type.getInternalName();
        cn = cn != null ? cn.replace('/', '.') : type.getClassName();
        return Classes.forName(cn);
    }

    public static Class<?>[] getArgumentClassTypes(MethodNode m) {
        Type[] argTypes = Type.getArgumentTypes(m.desc);
        if (argTypes == null || argTypes.length == 0) {
            return Arrays2.EMPTY_CLASS_ARRAY;
        }
        Class[] classTypes = new Class[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            classTypes[i] = ASM.getClassType(argTypes[i]);
        }
        return classTypes;
    }

    public static Type[] getArgumentTypes(MethodNode m) {
        return Type.getArgumentTypes(m.desc);
    }

    public static int getArgumentSize(MethodNode m) {
        return Type.getArgumentTypes(m.desc).length;
    }

    public static Type getReturnType(MethodNode m) {
        return Type.getReturnType(m.desc);
    }

    public static boolean hasArgument(MethodNode m) {
        return ASM.getArgumentSize(m) > 0;
    }

    public static boolean hasReturnValue(MethodNode m) {
        return Type.getReturnType(m.desc).getSort() != 0;
    }

    public static InsnNode nextInsnNode(AbstractInsnNode node, int opcode) {
        if (null == node) {
            return null;
        }
        do {
            if (node.getType() == 8 || node.getType() == 15) continue;
            if (node.getType() != 0) {
                return null;
            }
            InsnNode insn = (InsnNode)node;
            if (opcode != insn.getOpcode()) {
                return null;
            }
            return insn;
        } while ((node = node.getNext()) != null);
        return null;
    }

    public static void printASMifiedCodes(MethodNode m) {
        ASMifier1 p = new ASMifier1();
        PrintWriter pw = new PrintWriter(System.out);
        m.accept(new TraceMethodVisitor(p));
        p.print(pw);
        pw.flush();
    }

    public static void printASMifiedCode(byte[] data, PrintWriter out) {
        ClassReader cr = new ClassReader(data);
        cr.accept(new TraceClassVisitor(null, new ASMifier(), out), 8);
    }

    public static void printASMifiedCode(byte[] data) {
        ASM.printASMifiedCode(data, new PrintWriter(System.out));
    }

    public static void pintASMifiedCode(Class cls) {
        Resource r = Resources.getResource(cls);
        Try.throwUnchecked(() -> {
            try (InputStream is = r.getInputStream();){
                ClassReader cr = new ClassReader(is);
                ClassWriter cw = new ClassWriter(cr, 2);
                cr.accept(cw, 0);
                ASM.printASMifiedCode(cw.toByteArray(), new PrintWriter(System.out));
            }
        });
    }

    protected ASM() {
    }
}

