/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import leap.lang.Named;
import leap.lang.TypeInfo;
import leap.lang.accessor.AnnotationsGetter;
import leap.lang.accessor.TypeInfoGetter;
import leap.lang.beans.BeanType;
import leap.lang.convert.ConvertUnsupportedException;
import leap.lang.convert.Converts;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.reflect.ReflectField;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.ReflectValued;

public class BeanProperty
implements Named,
TypeInfoGetter,
AnnotationsGetter,
ReflectValued {
    private static final Log log = LogFactory.get(BeanProperty.class);
    private String name;
    private Class<?> type;
    private Type genericType;
    private TypeInfo typeInfo;
    private ReflectField field;
    private ReflectMethod getter;
    private ReflectMethod setter;
    private BeanType beanType;
    private boolean readable;
    private boolean writable;
    private boolean _transient;
    private Annotation[] annotations = new Annotation[0];

    protected BeanProperty(BeanType beanType, String name) {
        this.name = name;
        this.beanType = beanType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public Class<?> getElementType() {
        return this.typeInfo.getElementType();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public BeanType getBeanType() {
        return this.beanType;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public boolean isSimpleType() {
        return this.typeInfo.isSimpleType();
    }

    @Override
    public boolean isComplexType() {
        return this.typeInfo.isComplexType();
    }

    public boolean isField() {
        return null != this.field;
    }

    public boolean hasGetter() {
        return null != this.getter;
    }

    public boolean hasSetter() {
        return null != this.setter;
    }

    public Field getField() {
        return null != this.field ? this.field.getReflectedField() : null;
    }

    public ReflectField getReflectField() {
        return this.field;
    }

    public Method getSetter() {
        return null != this.setter ? this.setter.getReflectedMethod() : null;
    }

    public Method getGetter() {
        return null != this.getter ? this.getter.getReflectedMethod() : null;
    }

    @Override
    public Object getRawValue(Object bean) {
        return null != this.field ? this.field.getValue(bean) : this.getValue(bean);
    }

    @Override
    public Object getValue(Object bean) {
        if (!this.readable) {
            throw new IllegalStateException("Property '" + this.name + "' of '" + this.beanType.getBeanClass().getName() + "' not readable");
        }
        return null != this.getter ? this.getter.invoke(bean, new Object[0]) : this.field.getValue(bean, true);
    }

    @Override
    public void setValue(Object bean, Object value) {
        if (!this.writable) {
            throw new IllegalStateException("Property '" + this.name + "' of '" + this.beanType.getBeanClass().getName() + "' not writable");
        }
        if (null != value && !this.type.isAssignableFrom(value.getClass())) {
            value = Converts.convert(value, this.type, this.genericType);
        }
        if (null != this.setter) {
            this.setter.invoke(bean, value);
        } else {
            this.field.setValue(bean, value, true);
        }
    }

    public boolean trySetValue(Object bean, Object value) {
        if (this.writable) {
            try {
                if (null != value && !this.type.isAssignableFrom(value.getClass())) {
                    value = Converts.convert(value, this.type, this.genericType);
                }
                if (null != this.setter) {
                    this.setter.invoke(bean, value);
                } else {
                    this.field.setValue(bean, value, true);
                }
                return true;
            }
            catch (ConvertUnsupportedException e) {
                log.debug("cannot set property '{}' of bean '{}' -> {}", this.name, this.beanType.getBeanClass().getSimpleName(), e.getMessage());
            }
        }
        return false;
    }

    protected void setType(Class<?> type) {
        this.type = type;
    }

    protected void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    protected void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    protected void setField(ReflectField field) {
        this.field = field;
    }

    protected void setSetter(ReflectMethod setter) {
        this.setter = setter;
    }

    protected void setGetter(ReflectMethod getter) {
        this.getter = getter;
    }

    protected void setReadable(boolean readable) {
        this.readable = readable;
    }

    protected void setWritable(boolean writable) {
        this.writable = writable;
    }

    protected void setTransient(boolean isTransient) {
        this._transient = isTransient;
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String toString() {
        return "BeanProperty:" + this.beanType.getBeanClass().getName() + "#" + this.name;
    }
}

