/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.beans;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Types;
import leap.lang.beans.BeanProperty;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectField;
import leap.lang.reflect.ReflectMember;
import leap.lang.reflect.ReflectMethod;

public class BeanType {
    private static final Map<Class<?>, BeanType> cache = new ConcurrentHashMap();
    private final Map<Object, Object> attributes = Collections.synchronizedMap(new WeakHashMap(1));
    private final Class<?> beanClass;
    private final ReflectClass reflectClass;
    private final BeanProperty[] properties;
    private final Map<String, BeanProperty> originalNamePropertyMap;
    private final Map<String, BeanProperty> lowerCaseNamePropertyMap;

    public static BeanType of(Class<?> beanClass) {
        Args.notNull(beanClass, "bean class");
        BeanType accessor = cache.get(beanClass);
        if (null == accessor) {
            try {
                accessor = new BeanType(beanClass);
            }
            catch (Throwable e) {
                if (e instanceof ReflectException) {
                    throw (ReflectException)e;
                }
                throw new ReflectException("Error create bean type for class '" + beanClass.getName() + "' : " + e.getMessage(), e);
            }
            cache.put(beanClass, accessor);
        }
        return accessor;
    }

    protected BeanType(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.reflectClass = ReflectClass.of(beanClass);
        this.properties = this.initProperties();
        this.originalNamePropertyMap = this.createPropertyMap(false);
        this.lowerCaseNamePropertyMap = this.createPropertyMap(true);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public ReflectClass getReflectClass() {
        return this.reflectClass;
    }

    public BeanProperty[] getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String name) {
        return this.tryGetProperty(name) != null;
    }

    public BeanProperty getProperty(String name) throws ObjectNotFoundException {
        return this.getProperty(name, false);
    }

    public BeanProperty getProperty(String name, boolean ignorecase) throws ObjectNotFoundException {
        BeanProperty p;
        BeanProperty beanProperty = p = ignorecase ? this.lowerCaseNamePropertyMap.get(name.toLowerCase()) : this.originalNamePropertyMap.get(name);
        if (null == p) {
            throw new ObjectNotFoundException("property '" + name + "' not found in class '" + this.beanClass.getName() + "'");
        }
        return p;
    }

    public BeanProperty tryGetProperty(String name) {
        return this.originalNamePropertyMap.get(name);
    }

    public BeanProperty tryGetProperty(String name, boolean ignorecase) {
        return ignorecase ? this.lowerCaseNamePropertyMap.get(name.toLowerCase()) : this.originalNamePropertyMap.get(name);
    }

    public void setProperty(Object bean, String property, Object value) throws ObjectNotFoundException {
        this.getProperty(property).setValue(bean, value);
    }

    public void setProperty(Object bean, String property, Object value, boolean ignorecase) throws ObjectNotFoundException {
        this.getProperty(property, ignorecase).setValue(bean, value);
    }

    public boolean trySet(Object bean, String property, Object value) {
        BeanProperty prop = this.tryGetProperty(property);
        if (null != prop) {
            prop.setValue(bean, value);
            return true;
        }
        return false;
    }

    public boolean trySetIgnoreCase(Object bean, String property, Object value) {
        BeanProperty prop = this.tryGetProperty(property, true);
        if (null != prop) {
            prop.setValue(bean, value);
            return true;
        }
        return false;
    }

    public <T> T newInstance() {
        return this.reflectClass.newInstance();
    }

    public Map<String, Object> toMap(Object bean, Predicate<BeanProperty> predicate) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (BeanProperty p : this.properties) {
            if (!p.isReadable() || !predicate.test(p)) continue;
            map.put(p.getName(), p.getValue(bean));
        }
        return map;
    }

    public Map<String, Object> toMap(Object bean) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (BeanProperty p : this.properties) {
            if (!p.isReadable()) continue;
            map.put(p.getName(), p.getValue(bean));
        }
        return map;
    }

    private BeanProperty[] initProperties() {
        LinkedHashMap<String, BeanProperty> props = new LinkedHashMap<String, BeanProperty>();
        HashSet<Method> methods = new HashSet<Method>();
        for (ReflectField reflectField : this.reflectClass.getFields()) {
            String name;
            if (reflectField.isStatic() || !reflectField.isPublic() && !reflectField.hasGetter() && !reflectField.hasSetter() || props.containsKey(name = this.getTranditionalPropertyName(reflectField))) continue;
            BeanProperty prop = new BeanProperty(this, name);
            prop.setType(reflectField.getType());
            prop.setGenericType(reflectField.getGenericType());
            prop.setTypeInfo(Types.getTypeInfo(reflectField.getType(), reflectField.getGenericType()));
            prop.setField(reflectField);
            prop.setGetter(reflectField.getGetter());
            prop.setReadable(reflectField.isPublicGet());
            prop.setSetter(reflectField.getSetter());
            prop.setWritable(reflectField.isPublicSet() || reflectField.isPublic() && !reflectField.isFinal());
            prop.setTransient(reflectField.isTransient());
            prop.setAnnotations(reflectField.getReflectedField().getAnnotations());
            if (prop.hasGetter()) {
                methods.add(prop.getGetter());
                prop.setAnnotations(Arrays2.concat(prop.getAnnotations(), prop.getGetter().getAnnotations()));
            }
            if (prop.hasSetter()) {
                methods.add(prop.getSetter());
                prop.setAnnotations(Arrays2.concat(prop.getAnnotations(), prop.getSetter().getAnnotations()));
            }
            props.put(name, prop);
        }
        for (ReflectMember reflectMember : this.reflectClass.getMethods()) {
            BeanProperty prop;
            Method m = ((ReflectMethod)reflectMember).getReflectedMethod();
            if (((ReflectMethod)reflectMember).isStatic() || methods.contains(m)) continue;
            String methodName = ((ReflectMethod)reflectMember).getName();
            if (methodName.startsWith("set") && methodName.length() > "set".length()) {
                if (!m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 1 || null == (prop = this.getOrCreatePropertyFor(props, methodName, "set", m.getParameterTypes()[0]))) continue;
                prop.setSetter((ReflectMethod)reflectMember);
                prop.setWritable(((ReflectMethod)reflectMember).isPublic());
                if (null != prop.getGenericType()) continue;
                prop.setGenericType(m.getGenericParameterTypes()[0]);
                prop.setTypeInfo(Types.getTypeInfo(prop.getType(), prop.getGenericType()));
                prop.setAnnotations(Arrays2.concat(prop.getAnnotations(), m.getAnnotations()));
                continue;
            }
            if (methodName.startsWith("get") && methodName.length() > "get".length()) {
                if (m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 0 || null == (prop = this.getOrCreatePropertyFor(props, methodName, "get", m.getReturnType()))) continue;
                prop.setGetter((ReflectMethod)reflectMember);
                prop.setReadable(((ReflectMethod)reflectMember).isPublic());
                if (null != prop.getGenericType()) continue;
                prop.setGenericType(m.getGenericReturnType());
                prop.setTypeInfo(Types.getTypeInfo(prop.getType(), prop.getGenericType()));
                prop.setAnnotations(Arrays2.concat(prop.getAnnotations(), m.getAnnotations()));
                continue;
            }
            if (!methodName.startsWith("is") || methodName.length() <= "is".length() || !m.getReturnType().equals(Boolean.class) && !m.getReturnType().equals(Boolean.TYPE) || m.getParameterTypes().length != 0 || null == (prop = this.getOrCreatePropertyFor(props, methodName, "is", m.getReturnType())) || prop.hasGetter()) continue;
            prop.setGetter((ReflectMethod)reflectMember);
            prop.setReadable(((ReflectMethod)reflectMember).isPublic());
            if (null != prop.getGenericType()) continue;
            prop.setGenericType(m.getGenericReturnType());
            prop.setTypeInfo(Types.getTypeInfo(prop.getType(), prop.getGenericType()));
            prop.setAnnotations(Arrays2.concat(prop.getAnnotations(), m.getAnnotations()));
        }
        return props.values().toArray(new BeanProperty[props.size()]);
    }

    private BeanProperty getOrCreatePropertyFor(Map<String, BeanProperty> props, String methodName, String prefix, Class<?> type) {
        String propName = methodName.substring(prefix.length());
        char c = propName.charAt(0);
        if (Character.isUpperCase(c)) {
            propName = Character.toLowerCase(c) + propName.substring(1);
            BeanProperty prop = props.get(propName);
            if (null == prop) {
                prop = new BeanProperty(this, propName);
                prop.setType(type);
                props.put(propName, prop);
            } else if (!type.equals(prop.getType())) {
                return null;
            }
            return prop;
        }
        return null;
    }

    private String getTranditionalPropertyName(ReflectField field) {
        String name = null;
        name = field.hasSetter() ? field.getSetter().getName().substring("set".length()) : (field.hasGetter() ? ((name = field.getGetter().getName()).startsWith("is") ? name.substring("is".length()) : name.substring("get".length())) : (field.getName().startsWith("_") ? field.getName().substring(1) : field.getName()));
        return name.length() == 1 ? name.toLowerCase() : Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private Map<String, BeanProperty> createPropertyMap(boolean lowercase) {
        LinkedHashMap<String, BeanProperty> map = new LinkedHashMap<String, BeanProperty>(this.properties.length);
        for (BeanProperty p : this.properties) {
            map.put(lowercase ? p.getName().toLowerCase() : p.getName(), p);
        }
        return map;
    }

    public String toString() {
        return "BeanType:" + this.beanClass.getName();
    }
}

