/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.codec;

import leap.lang.Arrays2;
import leap.lang.Strings;

public class Base64 {
    static final byte PAD_DEFAULT = 61;
    static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String encode(byte[] data) {
        if (null == data) {
            return "";
        }
        return Strings.newStringUtf8(Base64.encodeToBytes(data));
    }

    public static String urlEncode(byte[] data) {
        if (null == data) {
            return "";
        }
        return Strings.newStringUtf8(Base64.urlEncodeToBytes(data));
    }

    public static String encode(String data) {
        if (null == data) {
            return "";
        }
        return Strings.newStringUtf8(Base64.encodeToBytes(data));
    }

    public static String urlEncode(String data) {
        if (null == data) {
            return "";
        }
        return Strings.newStringUtf8(Base64.urlEncodeToBytes(data));
    }

    public static byte[] encodeToBytes(byte[] data) {
        if (null == data) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        return java.util.Base64.getEncoder().encode(data);
    }

    public static byte[] urlEncodeToBytes(byte[] data) {
        if (null == data) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        return java.util.Base64.getUrlEncoder().encode(data);
    }

    public static byte[] encodeToBytes(String data) {
        if (null == data) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        return java.util.Base64.getEncoder().encode(Strings.getBytesUtf8(data));
    }

    public static byte[] urlEncodeToBytes(String data) {
        if (null == data) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        return java.util.Base64.getUrlEncoder().encode(Strings.getBytesUtf8(data));
    }

    public static byte[] decodeToBytes(String base64) {
        if (null == base64) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        return Base64.decodeToBytes(Strings.getBytesUtf8(base64));
    }

    public static byte[] decodeToBytes(byte[] base64Bytes) {
        if (null == base64Bytes) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        byte[] decodes = java.util.Base64.getDecoder().decode(base64Bytes);
        return decodes == null ? Arrays2.EMPTY_BYTE_ARRAY : decodes;
    }

    public static byte[] urlDecodeToBytes(byte[] base64Bytes) {
        if (null == base64Bytes) {
            return Arrays2.EMPTY_BYTE_ARRAY;
        }
        byte[] decodes = java.util.Base64.getUrlDecoder().decode(base64Bytes);
        return decodes == null ? Arrays2.EMPTY_BYTE_ARRAY : decodes;
    }

    public static String decode(String base64) {
        return Strings.newStringUtf8(Base64.decodeToBytes(base64));
    }

    public static String decode(byte[] base64) {
        return Strings.newStringUtf8(Base64.decodeToBytes(base64));
    }

    public static boolean isBase64(byte base64Byte) {
        return base64Byte == 61 || base64Byte >= 0 && base64Byte < DECODE_TABLE.length && DECODE_TABLE[base64Byte] != -1;
    }

    public static boolean isBase64(String base64) {
        return null == base64 ? false : Base64.isBase64(Strings.getBytesUtf8(base64));
    }

    public static boolean isBase64(byte[] base64Bytes) {
        if (null == base64Bytes) {
            return false;
        }
        for (int i = 0; i < base64Bytes.length; ++i) {
            if (Base64.isBase64(base64Bytes[i]) || Base64.isWhiteSpace(base64Bytes[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    protected Base64() {
    }
}

