/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.codec;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import leap.lang.Strings;
import leap.lang.codec.Base64;
import leap.lang.codec.Hex;

public class Digests {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] md5(byte[] data) {
        return Digests.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return Digests.digest(Digests.getMd5Digest(), data);
    }

    public static byte[] md5(String data) {
        return Digests.md5(Digests.getBytesUtf8(data));
    }

    public static String md5Base64(byte[] data) {
        return Base64.encode(Digests.md5(data));
    }

    public static String md5Base64(String data) {
        return Base64.encode(Digests.md5(data));
    }

    public static String md5Base64(InputStream data) throws IOException {
        return Base64.encode(Digests.md5(data));
    }

    public static String md5Hex(byte[] data) {
        return Hex.encode(Digests.md5(data));
    }

    public static String md5Hex(String data) {
        return Hex.encode(Digests.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return Hex.encode(Digests.md5(data));
    }

    public static byte[] sha(byte[] data) {
        return Digests.getShaDigest().digest(data);
    }

    public static byte[] sha(InputStream data) throws IOException {
        return Digests.digest(Digests.getShaDigest(), data);
    }

    public static byte[] sha(String data) {
        return Digests.sha(Digests.getBytesUtf8(data));
    }

    public static String shaHex(byte[] data) {
        return Hex.encode(Digests.sha(data));
    }

    public static String shaHex(InputStream data) throws IOException {
        return Hex.encode(Digests.sha(data));
    }

    public static String shaHex(String data) {
        return Hex.encode(Digests.sha(data));
    }

    public static byte[] sha256(byte[] data) {
        return Digests.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) throws IOException {
        return Digests.digest(Digests.getSha256Digest(), data);
    }

    public static byte[] sha256(String data) {
        return Digests.sha256(Digests.getBytesUtf8(data));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encode(Digests.sha256(data));
    }

    public static String sha256Hex(InputStream data) throws IOException {
        return Hex.encode(Digests.sha256(data));
    }

    public static String sha256Hex(String data) {
        return Hex.encode(Digests.sha256(data));
    }

    public static byte[] sha384(byte[] data) {
        return Digests.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) throws IOException {
        return Digests.digest(Digests.getSha384Digest(), data);
    }

    public static byte[] sha384(String data) {
        return Digests.sha384(Digests.getBytesUtf8(data));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encode(Digests.sha384(data));
    }

    public static String sha384Hex(InputStream data) throws IOException {
        return Hex.encode(Digests.sha384(data));
    }

    public static String sha384Hex(String data) {
        return Hex.encode(Digests.sha384(data));
    }

    public static byte[] sha512(byte[] data) {
        return Digests.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) throws IOException {
        return Digests.digest(Digests.getSha512Digest(), data);
    }

    public static byte[] sha512(String data) {
        return Digests.sha512(Digests.getBytesUtf8(data));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encode(Digests.sha512(data));
    }

    public static String sha512Hex(InputStream data) throws IOException {
        return Hex.encode(Digests.sha512(data));
    }

    public static String sha512Hex(String data) {
        return Hex.encode(Digests.sha512(data));
    }

    private static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    private static byte[] getBytesUtf8(String data) {
        return Strings.getBytesUtf8(data);
    }

    private static MessageDigest getMd5Digest() {
        return Digests.getDigest("MD5");
    }

    private static MessageDigest getSha256Digest() {
        return Digests.getDigest("SHA-256");
    }

    private static MessageDigest getSha384Digest() {
        return Digests.getDigest("SHA-384");
    }

    private static MessageDigest getSha512Digest() {
        return Digests.getDigest("SHA-512");
    }

    private static MessageDigest getShaDigest() {
        return Digests.getDigest("SHA");
    }
}

