/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.codec;

import java.util.Arrays;
import leap.lang.codec.HexCommonsImpl;

public class Hex {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] HEX_CHARS = Hex.initHexChars();

    private static int[] initHexChars() {
        int c;
        int[] chars = new int[128];
        Arrays.fill(chars, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            chars[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            chars[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            chars[c] = c - 97 + 10;
        }
        return chars;
    }

    public static boolean isHexCharacter(char c) {
        return c < '\u0080' && HEX_CHARS[c] != -1;
    }

    public static String encode(byte[] data) {
        return HexCommonsImpl.encodeHexString(data);
    }

    public static String encode(byte[] data, boolean toLowerCase) {
        return new String(HexCommonsImpl.encodeHex(data, toLowerCase));
    }

    public static char[] encodeToChars(byte[] data) {
        return HexCommonsImpl.encodeHex(data);
    }

    public static char[] encodeToChars(byte[] data, boolean toLowerCase) {
        return HexCommonsImpl.encodeHex(data, toLowerCase);
    }

    public static byte[] decode(String hex) {
        return HexCommonsImpl.decodeHex(hex.toCharArray());
    }

    public static byte[] decode(char[] hex) {
        return HexCommonsImpl.decodeHex(hex);
    }

    protected Hex() {
    }
}

